/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.item;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.manuflosoyt.supermod.init.SupermodModItems;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber
public abstract class EndiumArmorItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 20);
                map.put(ArmorItem.Type.LEGGINGS, 240);
                map.put(ArmorItem.Type.CHESTPLATE, 200);
                map.put(ArmorItem.Type.HELMET, 80);
                map.put(ArmorItem.Type.BODY, 200);
            }), 100, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_netherite")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)SupermodModItems.ENDIUM_INGOT.get())}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"supermod:endium_"))), 10.0f, 1.0f);
            registerHelper.register(ResourceLocation.parse((String)"supermod:endium_armor"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    public EndiumArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends EndiumArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(200)).fireResistant());
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }

    public static class Leggings
    extends EndiumArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(200)).fireResistant());
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }

    public static class Chestplate
    extends EndiumArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(200)).fireResistant());
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }

    public static class Helmet
    extends EndiumArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(200)).fireResistant());
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }
}

