/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.network;

import net.manuflosoyt.supermod.SupermodMod;
import net.manuflosoyt.supermod.procedures.MinezonAdd1ToItemAmmountProcedure;
import net.manuflosoyt.supermod.procedures.MinezonAdd1toIDProcedure;
import net.manuflosoyt.supermod.procedures.MinezonBuyProcedure;
import net.manuflosoyt.supermod.procedures.MinezonSellProcedure;
import net.manuflosoyt.supermod.procedures.MinezonSetAmmountToX16Procedure;
import net.manuflosoyt.supermod.procedures.MinezonSetAmmountToX1Procedure;
import net.manuflosoyt.supermod.procedures.MinezonSetAmmountToX32Procedure;
import net.manuflosoyt.supermod.procedures.MinezonSetAmmountToX64Procedure;
import net.manuflosoyt.supermod.procedures.MinezonSubstract1ToItemAmmountProcedure;
import net.manuflosoyt.supermod.procedures.MinezonSubstract1toIDProcedure;
import net.manuflosoyt.supermod.procedures.MinezonTextFieldSelectProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record MinezonButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MinezonButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"supermod", (String)"minezon_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MinezonButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MinezonButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MinezonButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MinezonButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MinezonButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MinezonSubstract1toIDProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            MinezonAdd1toIDProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            MinezonAdd1ToItemAmmountProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            MinezonSubstract1ToItemAmmountProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            MinezonSetAmmountToX64Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            MinezonSetAmmountToX32Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            MinezonSetAmmountToX16Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            MinezonSetAmmountToX1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 8) {
            MinezonSellProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            MinezonTextFieldSelectProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 10) {
            MinezonBuyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SupermodMod.addNetworkMessage(TYPE, STREAM_CODEC, MinezonButtonMessage::handleData);
    }
}

