/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.network;

import java.util.function.Supplier;
import net.manuflosoyt.supermod.SupermodMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class SupermodModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"supermod");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SupermodMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        SupermodMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(SupermodModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(SupermodModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.money = original.money;
        clone.first_login = original.first_login;
        clone.minezon_ammount = original.minezon_ammount;
        clone.minezon_ID = original.minezon_ID;
        clone.minezon_price = original.minezon_price;
        clone.minezon_single_item_price = original.minezon_single_item_price;
        clone.StoredGravity = original.StoredGravity;
        if (!event.isWasDeath()) {
            // empty if block
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (mapdata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
            if (worldVariables._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level2, (CustomPacketPayload)new SavedDataSyncMessage(1, worldVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                worldVariables._syncDirty = false;
            }
            MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
            if (mapVariables._syncDirty) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, mapVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                mapVariables._syncDirty = false;
            }
        }
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"supermod", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"supermod", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public double money = 0.0;
        public boolean first_login = true;
        public double minezon_ammount = 1.0;
        public double minezon_ID = 0.0;
        public double minezon_price = 0.0;
        public double minezon_single_item_price = 0.0;
        public double StoredGravity = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("money", this.money);
            nbt.putBoolean("first_login", this.first_login);
            nbt.putDouble("minezon_ammount", this.minezon_ammount);
            nbt.putDouble("minezon_ID", this.minezon_ID);
            nbt.putDouble("minezon_price", this.minezon_price);
            nbt.putDouble("minezon_single_item_price", this.minezon_single_item_price);
            nbt.putDouble("StoredGravity", this.StoredGravity);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.money = nbt.getDouble("money");
            this.first_login = nbt.getBoolean("first_login");
            this.minezon_ammount = nbt.getDouble("minezon_ammount");
            this.minezon_ID = nbt.getDouble("minezon_ID");
            this.minezon_price = nbt.getDouble("minezon_price");
            this.minezon_single_item_price = nbt.getDouble("minezon_single_item_price");
            this.StoredGravity = nbt.getDouble("StoredGravity");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "supermod_mapvars";
        boolean _syncDirty = false;
        public String update = "3.3.1";
        public double minezon_MAX_ID = 0.0;
        public ItemStack Minezon0 = ItemStack.EMPTY;
        public ItemStack Minezon1 = ItemStack.EMPTY;
        public ItemStack Minezon2 = ItemStack.EMPTY;
        public ItemStack Minezon3 = ItemStack.EMPTY;
        public ItemStack Minezon4 = ItemStack.EMPTY;
        public ItemStack Minezon5 = ItemStack.EMPTY;
        public ItemStack Minezon6 = ItemStack.EMPTY;
        public ItemStack Minezon7 = ItemStack.EMPTY;
        public ItemStack Minezon8 = ItemStack.EMPTY;
        public ItemStack Minezon9 = ItemStack.EMPTY;
        public ItemStack Minezon10 = ItemStack.EMPTY;
        public ItemStack Minezon11 = ItemStack.EMPTY;
        public ItemStack Minezon12 = ItemStack.EMPTY;
        public ItemStack Minezon13 = ItemStack.EMPTY;
        public ItemStack Minezon14 = ItemStack.EMPTY;
        public double forgeFlow = 0.0;
        public ItemStack Minezon15 = ItemStack.EMPTY;
        public ItemStack Minezon16 = ItemStack.EMPTY;
        public ItemStack Minezon17 = ItemStack.EMPTY;
        public ItemStack Minezon18 = ItemStack.EMPTY;
        public ItemStack Minezon19 = ItemStack.EMPTY;
        public ItemStack Minezon20 = ItemStack.EMPTY;
        public ItemStack Minezon21 = ItemStack.EMPTY;
        public ItemStack Minezon22 = ItemStack.EMPTY;
        public ItemStack Minezon23 = ItemStack.EMPTY;
        public ItemStack Minezon24 = ItemStack.EMPTY;
        public ItemStack Minezon25 = ItemStack.EMPTY;
        public ItemStack Minezon26 = ItemStack.EMPTY;
        public ItemStack Minezon27 = ItemStack.EMPTY;
        public ItemStack Minezon28 = ItemStack.EMPTY;
        public ItemStack Minezon29 = ItemStack.EMPTY;
        public ItemStack Minezon30 = ItemStack.EMPTY;
        public ItemStack Minezon31 = ItemStack.EMPTY;
        public ItemStack Minezon32 = ItemStack.EMPTY;
        public ItemStack Minezon33 = ItemStack.EMPTY;
        public ItemStack Minezon34 = ItemStack.EMPTY;
        public ItemStack Minezon35 = ItemStack.EMPTY;
        public ItemStack Minezon36 = ItemStack.EMPTY;
        public ItemStack Minezon37 = ItemStack.EMPTY;
        public ItemStack Minezon38 = ItemStack.EMPTY;
        public ItemStack Minezon39 = ItemStack.EMPTY;
        public ItemStack Minezon40 = ItemStack.EMPTY;
        public ItemStack Minezon41 = ItemStack.EMPTY;
        public ItemStack Minezon42 = ItemStack.EMPTY;
        public ItemStack Minezon43 = ItemStack.EMPTY;
        public ItemStack Minezon44 = ItemStack.EMPTY;
        public ItemStack Minezon45 = ItemStack.EMPTY;
        public ItemStack Minezon46 = ItemStack.EMPTY;
        public ItemStack Minezon47 = ItemStack.EMPTY;
        public ItemStack Minezon48 = ItemStack.EMPTY;
        public ItemStack Minezon49 = ItemStack.EMPTY;
        public ItemStack Minezon50 = ItemStack.EMPTY;
        public ItemStack Minezon51 = ItemStack.EMPTY;
        public ItemStack Minezon52 = ItemStack.EMPTY;
        public ItemStack Minezon53 = ItemStack.EMPTY;
        public ItemStack Minezon54 = ItemStack.EMPTY;
        public ItemStack Minezon55 = ItemStack.EMPTY;
        public ItemStack Minezon56 = ItemStack.EMPTY;
        public ItemStack Minezon57 = ItemStack.EMPTY;
        public ItemStack Minezon58 = ItemStack.EMPTY;
        public ItemStack Minezon59 = ItemStack.EMPTY;
        public ItemStack Minezon60 = ItemStack.EMPTY;
        public ItemStack Minezon61 = ItemStack.EMPTY;
        public ItemStack Minezon62 = ItemStack.EMPTY;
        public ItemStack Minezon63 = ItemStack.EMPTY;
        public ItemStack Minezon64 = ItemStack.EMPTY;
        public ItemStack Minezon65 = ItemStack.EMPTY;
        public ItemStack Minezon66 = ItemStack.EMPTY;
        public ItemStack Minezon67 = ItemStack.EMPTY;
        public ItemStack Minezon68 = ItemStack.EMPTY;
        public ItemStack Minezon69 = ItemStack.EMPTY;
        public ItemStack Minezon70 = ItemStack.EMPTY;
        public ItemStack Minezon71 = ItemStack.EMPTY;
        public ItemStack Minezon72 = ItemStack.EMPTY;
        public ItemStack Minezon73 = ItemStack.EMPTY;
        public ItemStack Minezon74 = ItemStack.EMPTY;
        public ItemStack Minezon75 = ItemStack.EMPTY;
        public ItemStack Minezon76 = ItemStack.EMPTY;
        public ItemStack Minezon77 = ItemStack.EMPTY;
        public ItemStack Minezon78 = ItemStack.EMPTY;
        public ItemStack Minezon79 = ItemStack.EMPTY;
        public ItemStack Minezon80 = ItemStack.EMPTY;
        public ItemStack Minezon81 = ItemStack.EMPTY;
        public ItemStack Minezon82 = ItemStack.EMPTY;
        public ItemStack Minezon83 = ItemStack.EMPTY;
        public ItemStack Minezon84 = ItemStack.EMPTY;
        public ItemStack Minezon85 = ItemStack.EMPTY;
        public ItemStack Minezon86 = ItemStack.EMPTY;
        public ItemStack Minezon87 = ItemStack.EMPTY;
        public ItemStack Minezon88 = ItemStack.EMPTY;
        public ItemStack Minezon89 = ItemStack.EMPTY;
        public ItemStack Minezon90 = ItemStack.EMPTY;
        public ItemStack Minezon91 = ItemStack.EMPTY;
        public ItemStack Minezon92 = ItemStack.EMPTY;
        public ItemStack Minezon93 = ItemStack.EMPTY;
        public ItemStack Minezon94 = ItemStack.EMPTY;
        public ItemStack Minezon95 = ItemStack.EMPTY;
        public ItemStack Minezon96 = ItemStack.EMPTY;
        public ItemStack Minezon97 = ItemStack.EMPTY;
        public ItemStack Minezon98 = ItemStack.EMPTY;
        public ItemStack Minezon99 = ItemStack.EMPTY;
        public ItemStack Minezon100 = ItemStack.EMPTY;
        public ItemStack Minezon101 = ItemStack.EMPTY;
        public ItemStack Minezon102 = ItemStack.EMPTY;
        public ItemStack Minezon103 = ItemStack.EMPTY;
        public ItemStack Minezon104 = ItemStack.EMPTY;
        public ItemStack Minezon105 = ItemStack.EMPTY;
        public ItemStack Minezon106 = ItemStack.EMPTY;
        public ItemStack Minezon107 = ItemStack.EMPTY;
        public ItemStack Minezon108 = ItemStack.EMPTY;
        public ItemStack Minezon109 = ItemStack.EMPTY;
        public ItemStack Minezon110 = ItemStack.EMPTY;
        public ItemStack Minezon111 = ItemStack.EMPTY;
        public ItemStack Minezon112 = ItemStack.EMPTY;
        public ItemStack Minezon113 = ItemStack.EMPTY;
        public ItemStack Minezon114 = ItemStack.EMPTY;
        public ItemStack Minezon115 = ItemStack.EMPTY;
        public ItemStack Minezon116 = ItemStack.EMPTY;
        public ItemStack Minezon117 = ItemStack.EMPTY;
        public ItemStack Minezon118 = ItemStack.EMPTY;
        public ItemStack Minezon119 = ItemStack.EMPTY;
        public ItemStack Minezon120 = ItemStack.EMPTY;
        public ItemStack Minezon121 = ItemStack.EMPTY;
        public ItemStack Minezon122 = ItemStack.EMPTY;
        public ItemStack Minezon123 = ItemStack.EMPTY;
        public ItemStack Minezon124 = ItemStack.EMPTY;
        public ItemStack Minezon125 = ItemStack.EMPTY;
        public ItemStack Minezon126 = ItemStack.EMPTY;
        public ItemStack Minezon127 = ItemStack.EMPTY;
        public ItemStack Minezon128 = ItemStack.EMPTY;
        public ItemStack Minezon129 = ItemStack.EMPTY;
        public ItemStack Minezon130 = ItemStack.EMPTY;
        public ItemStack Minezon131 = ItemStack.EMPTY;
        public ItemStack Minezon132 = ItemStack.EMPTY;
        public ItemStack Minezon133 = ItemStack.EMPTY;
        public ItemStack Minezon134 = ItemStack.EMPTY;
        public ItemStack Minezon135 = ItemStack.EMPTY;
        public ItemStack Minezon136 = ItemStack.EMPTY;
        public ItemStack Minezon137 = ItemStack.EMPTY;
        public ItemStack Minezon138 = ItemStack.EMPTY;
        public ItemStack Minezon139 = ItemStack.EMPTY;
        public ItemStack Minezon140 = ItemStack.EMPTY;
        public ItemStack Minezon141 = ItemStack.EMPTY;
        public ItemStack Minezon142 = ItemStack.EMPTY;
        public ItemStack Minezon143 = ItemStack.EMPTY;
        public ItemStack Minezon144 = ItemStack.EMPTY;
        public ItemStack Minezon145 = ItemStack.EMPTY;
        public ItemStack Minezon146 = ItemStack.EMPTY;
        public ItemStack Minezon147 = ItemStack.EMPTY;
        public ItemStack Minezon148 = ItemStack.EMPTY;
        public ItemStack Minezon149 = ItemStack.EMPTY;
        public ItemStack Minezon150 = ItemStack.EMPTY;
        public ItemStack Minezon151 = ItemStack.EMPTY;
        public ItemStack Minezon152 = ItemStack.EMPTY;
        public ItemStack Minezon153 = ItemStack.EMPTY;
        public ItemStack Minezon154 = ItemStack.EMPTY;
        public ItemStack Minezon155 = ItemStack.EMPTY;
        public ItemStack Minezon156 = ItemStack.EMPTY;
        public ItemStack Minezon157 = ItemStack.EMPTY;
        public ItemStack Minezon158 = ItemStack.EMPTY;
        public ItemStack Minezon159 = ItemStack.EMPTY;
        public ItemStack Minezon160 = ItemStack.EMPTY;
        public ItemStack Minezon161 = ItemStack.EMPTY;
        public ItemStack Minezon162 = ItemStack.EMPTY;
        public ItemStack Minezon163 = ItemStack.EMPTY;
        public ItemStack Minezon164 = ItemStack.EMPTY;
        public ItemStack Minezon165 = ItemStack.EMPTY;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.update = nbt.getString("update");
            this.minezon_MAX_ID = nbt.getDouble("minezon_MAX_ID");
            this.Minezon0 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon0"));
            this.Minezon1 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon1"));
            this.Minezon2 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon2"));
            this.Minezon3 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon3"));
            this.Minezon4 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon4"));
            this.Minezon5 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon5"));
            this.Minezon6 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon6"));
            this.Minezon7 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon7"));
            this.Minezon8 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon8"));
            this.Minezon9 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon9"));
            this.Minezon10 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon10"));
            this.Minezon11 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon11"));
            this.Minezon12 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon12"));
            this.Minezon13 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon13"));
            this.Minezon14 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon14"));
            this.forgeFlow = nbt.getDouble("forgeFlow");
            this.Minezon15 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon15"));
            this.Minezon16 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon16"));
            this.Minezon17 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon17"));
            this.Minezon18 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon18"));
            this.Minezon19 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon19"));
            this.Minezon20 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon20"));
            this.Minezon21 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon21"));
            this.Minezon22 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon22"));
            this.Minezon23 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon23"));
            this.Minezon24 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon24"));
            this.Minezon25 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon25"));
            this.Minezon26 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon26"));
            this.Minezon27 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon27"));
            this.Minezon28 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon28"));
            this.Minezon29 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon29"));
            this.Minezon30 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon30"));
            this.Minezon31 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon31"));
            this.Minezon32 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon32"));
            this.Minezon33 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon33"));
            this.Minezon34 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon34"));
            this.Minezon35 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon35"));
            this.Minezon36 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon36"));
            this.Minezon37 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon37"));
            this.Minezon38 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon38"));
            this.Minezon39 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon39"));
            this.Minezon40 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon40"));
            this.Minezon41 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon41"));
            this.Minezon42 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon42"));
            this.Minezon43 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon43"));
            this.Minezon44 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon44"));
            this.Minezon45 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon45"));
            this.Minezon46 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon46"));
            this.Minezon47 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon47"));
            this.Minezon48 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon48"));
            this.Minezon49 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon49"));
            this.Minezon50 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon50"));
            this.Minezon51 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon51"));
            this.Minezon52 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon52"));
            this.Minezon53 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon53"));
            this.Minezon54 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon54"));
            this.Minezon55 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon55"));
            this.Minezon56 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon56"));
            this.Minezon57 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon57"));
            this.Minezon58 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon58"));
            this.Minezon59 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon59"));
            this.Minezon60 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon60"));
            this.Minezon61 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon61"));
            this.Minezon62 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon62"));
            this.Minezon63 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon63"));
            this.Minezon64 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon64"));
            this.Minezon65 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon65"));
            this.Minezon66 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon66"));
            this.Minezon67 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon67"));
            this.Minezon68 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon68"));
            this.Minezon69 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon69"));
            this.Minezon70 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon70"));
            this.Minezon71 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon71"));
            this.Minezon72 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon72"));
            this.Minezon73 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon73"));
            this.Minezon74 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon74"));
            this.Minezon75 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon75"));
            this.Minezon76 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon76"));
            this.Minezon77 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon77"));
            this.Minezon78 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon78"));
            this.Minezon79 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon79"));
            this.Minezon80 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon80"));
            this.Minezon81 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon81"));
            this.Minezon82 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon82"));
            this.Minezon83 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon83"));
            this.Minezon84 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon84"));
            this.Minezon85 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon85"));
            this.Minezon86 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon86"));
            this.Minezon87 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon87"));
            this.Minezon88 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon88"));
            this.Minezon89 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon89"));
            this.Minezon90 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon90"));
            this.Minezon91 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon91"));
            this.Minezon92 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon92"));
            this.Minezon93 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon93"));
            this.Minezon94 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon94"));
            this.Minezon95 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon95"));
            this.Minezon96 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon96"));
            this.Minezon97 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon97"));
            this.Minezon98 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon98"));
            this.Minezon99 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon99"));
            this.Minezon100 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon100"));
            this.Minezon101 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon101"));
            this.Minezon102 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon102"));
            this.Minezon103 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon103"));
            this.Minezon104 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon104"));
            this.Minezon105 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon105"));
            this.Minezon106 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon106"));
            this.Minezon107 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon107"));
            this.Minezon108 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon108"));
            this.Minezon109 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon109"));
            this.Minezon110 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon110"));
            this.Minezon111 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon111"));
            this.Minezon112 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon112"));
            this.Minezon113 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon113"));
            this.Minezon114 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon114"));
            this.Minezon115 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon115"));
            this.Minezon116 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon116"));
            this.Minezon117 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon117"));
            this.Minezon118 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon118"));
            this.Minezon119 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon119"));
            this.Minezon120 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon120"));
            this.Minezon121 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon121"));
            this.Minezon122 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon122"));
            this.Minezon123 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon123"));
            this.Minezon124 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon124"));
            this.Minezon125 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon125"));
            this.Minezon126 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon126"));
            this.Minezon127 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon127"));
            this.Minezon128 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon128"));
            this.Minezon129 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon129"));
            this.Minezon130 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon130"));
            this.Minezon131 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon131"));
            this.Minezon132 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon132"));
            this.Minezon133 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon133"));
            this.Minezon134 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon134"));
            this.Minezon135 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon135"));
            this.Minezon136 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon136"));
            this.Minezon137 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon137"));
            this.Minezon138 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon138"));
            this.Minezon139 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon139"));
            this.Minezon140 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon140"));
            this.Minezon141 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon141"));
            this.Minezon142 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon142"));
            this.Minezon143 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon143"));
            this.Minezon144 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon144"));
            this.Minezon145 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon145"));
            this.Minezon146 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon146"));
            this.Minezon147 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon147"));
            this.Minezon148 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon148"));
            this.Minezon149 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon149"));
            this.Minezon150 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon150"));
            this.Minezon151 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon151"));
            this.Minezon152 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon152"));
            this.Minezon153 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon153"));
            this.Minezon154 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon154"));
            this.Minezon155 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon155"));
            this.Minezon156 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon156"));
            this.Minezon157 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon157"));
            this.Minezon158 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon158"));
            this.Minezon159 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon159"));
            this.Minezon160 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon160"));
            this.Minezon161 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon161"));
            this.Minezon162 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon162"));
            this.Minezon163 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon163"));
            this.Minezon164 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon164"));
            this.Minezon165 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Minezon165"));
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putString("update", this.update);
            nbt.putDouble("minezon_MAX_ID", this.minezon_MAX_ID);
            nbt.put("Minezon0", this.Minezon0.saveOptional(lookupProvider));
            nbt.put("Minezon1", this.Minezon1.saveOptional(lookupProvider));
            nbt.put("Minezon2", this.Minezon2.saveOptional(lookupProvider));
            nbt.put("Minezon3", this.Minezon3.saveOptional(lookupProvider));
            nbt.put("Minezon4", this.Minezon4.saveOptional(lookupProvider));
            nbt.put("Minezon5", this.Minezon5.saveOptional(lookupProvider));
            nbt.put("Minezon6", this.Minezon6.saveOptional(lookupProvider));
            nbt.put("Minezon7", this.Minezon7.saveOptional(lookupProvider));
            nbt.put("Minezon8", this.Minezon8.saveOptional(lookupProvider));
            nbt.put("Minezon9", this.Minezon9.saveOptional(lookupProvider));
            nbt.put("Minezon10", this.Minezon10.saveOptional(lookupProvider));
            nbt.put("Minezon11", this.Minezon11.saveOptional(lookupProvider));
            nbt.put("Minezon12", this.Minezon12.saveOptional(lookupProvider));
            nbt.put("Minezon13", this.Minezon13.saveOptional(lookupProvider));
            nbt.put("Minezon14", this.Minezon14.saveOptional(lookupProvider));
            nbt.putDouble("forgeFlow", this.forgeFlow);
            nbt.put("Minezon15", this.Minezon15.saveOptional(lookupProvider));
            nbt.put("Minezon16", this.Minezon16.saveOptional(lookupProvider));
            nbt.put("Minezon17", this.Minezon17.saveOptional(lookupProvider));
            nbt.put("Minezon18", this.Minezon18.saveOptional(lookupProvider));
            nbt.put("Minezon19", this.Minezon19.saveOptional(lookupProvider));
            nbt.put("Minezon20", this.Minezon20.saveOptional(lookupProvider));
            nbt.put("Minezon21", this.Minezon21.saveOptional(lookupProvider));
            nbt.put("Minezon22", this.Minezon22.saveOptional(lookupProvider));
            nbt.put("Minezon23", this.Minezon23.saveOptional(lookupProvider));
            nbt.put("Minezon24", this.Minezon24.saveOptional(lookupProvider));
            nbt.put("Minezon25", this.Minezon25.saveOptional(lookupProvider));
            nbt.put("Minezon26", this.Minezon26.saveOptional(lookupProvider));
            nbt.put("Minezon27", this.Minezon27.saveOptional(lookupProvider));
            nbt.put("Minezon28", this.Minezon28.saveOptional(lookupProvider));
            nbt.put("Minezon29", this.Minezon29.saveOptional(lookupProvider));
            nbt.put("Minezon30", this.Minezon30.saveOptional(lookupProvider));
            nbt.put("Minezon31", this.Minezon31.saveOptional(lookupProvider));
            nbt.put("Minezon32", this.Minezon32.saveOptional(lookupProvider));
            nbt.put("Minezon33", this.Minezon33.saveOptional(lookupProvider));
            nbt.put("Minezon34", this.Minezon34.saveOptional(lookupProvider));
            nbt.put("Minezon35", this.Minezon35.saveOptional(lookupProvider));
            nbt.put("Minezon36", this.Minezon36.saveOptional(lookupProvider));
            nbt.put("Minezon37", this.Minezon37.saveOptional(lookupProvider));
            nbt.put("Minezon38", this.Minezon38.saveOptional(lookupProvider));
            nbt.put("Minezon39", this.Minezon39.saveOptional(lookupProvider));
            nbt.put("Minezon40", this.Minezon40.saveOptional(lookupProvider));
            nbt.put("Minezon41", this.Minezon41.saveOptional(lookupProvider));
            nbt.put("Minezon42", this.Minezon42.saveOptional(lookupProvider));
            nbt.put("Minezon43", this.Minezon43.saveOptional(lookupProvider));
            nbt.put("Minezon44", this.Minezon44.saveOptional(lookupProvider));
            nbt.put("Minezon45", this.Minezon45.saveOptional(lookupProvider));
            nbt.put("Minezon46", this.Minezon46.saveOptional(lookupProvider));
            nbt.put("Minezon47", this.Minezon47.saveOptional(lookupProvider));
            nbt.put("Minezon48", this.Minezon48.saveOptional(lookupProvider));
            nbt.put("Minezon49", this.Minezon49.saveOptional(lookupProvider));
            nbt.put("Minezon50", this.Minezon50.saveOptional(lookupProvider));
            nbt.put("Minezon51", this.Minezon51.saveOptional(lookupProvider));
            nbt.put("Minezon52", this.Minezon52.saveOptional(lookupProvider));
            nbt.put("Minezon53", this.Minezon53.saveOptional(lookupProvider));
            nbt.put("Minezon54", this.Minezon54.saveOptional(lookupProvider));
            nbt.put("Minezon55", this.Minezon55.saveOptional(lookupProvider));
            nbt.put("Minezon56", this.Minezon56.saveOptional(lookupProvider));
            nbt.put("Minezon57", this.Minezon57.saveOptional(lookupProvider));
            nbt.put("Minezon58", this.Minezon58.saveOptional(lookupProvider));
            nbt.put("Minezon59", this.Minezon59.saveOptional(lookupProvider));
            nbt.put("Minezon60", this.Minezon60.saveOptional(lookupProvider));
            nbt.put("Minezon61", this.Minezon61.saveOptional(lookupProvider));
            nbt.put("Minezon62", this.Minezon62.saveOptional(lookupProvider));
            nbt.put("Minezon63", this.Minezon63.saveOptional(lookupProvider));
            nbt.put("Minezon64", this.Minezon64.saveOptional(lookupProvider));
            nbt.put("Minezon65", this.Minezon65.saveOptional(lookupProvider));
            nbt.put("Minezon66", this.Minezon66.saveOptional(lookupProvider));
            nbt.put("Minezon67", this.Minezon67.saveOptional(lookupProvider));
            nbt.put("Minezon68", this.Minezon68.saveOptional(lookupProvider));
            nbt.put("Minezon69", this.Minezon69.saveOptional(lookupProvider));
            nbt.put("Minezon70", this.Minezon70.saveOptional(lookupProvider));
            nbt.put("Minezon71", this.Minezon71.saveOptional(lookupProvider));
            nbt.put("Minezon72", this.Minezon72.saveOptional(lookupProvider));
            nbt.put("Minezon73", this.Minezon73.saveOptional(lookupProvider));
            nbt.put("Minezon74", this.Minezon74.saveOptional(lookupProvider));
            nbt.put("Minezon75", this.Minezon75.saveOptional(lookupProvider));
            nbt.put("Minezon76", this.Minezon76.saveOptional(lookupProvider));
            nbt.put("Minezon77", this.Minezon77.saveOptional(lookupProvider));
            nbt.put("Minezon78", this.Minezon78.saveOptional(lookupProvider));
            nbt.put("Minezon79", this.Minezon79.saveOptional(lookupProvider));
            nbt.put("Minezon80", this.Minezon80.saveOptional(lookupProvider));
            nbt.put("Minezon81", this.Minezon81.saveOptional(lookupProvider));
            nbt.put("Minezon82", this.Minezon82.saveOptional(lookupProvider));
            nbt.put("Minezon83", this.Minezon83.saveOptional(lookupProvider));
            nbt.put("Minezon84", this.Minezon84.saveOptional(lookupProvider));
            nbt.put("Minezon85", this.Minezon85.saveOptional(lookupProvider));
            nbt.put("Minezon86", this.Minezon86.saveOptional(lookupProvider));
            nbt.put("Minezon87", this.Minezon87.saveOptional(lookupProvider));
            nbt.put("Minezon88", this.Minezon88.saveOptional(lookupProvider));
            nbt.put("Minezon89", this.Minezon89.saveOptional(lookupProvider));
            nbt.put("Minezon90", this.Minezon90.saveOptional(lookupProvider));
            nbt.put("Minezon91", this.Minezon91.saveOptional(lookupProvider));
            nbt.put("Minezon92", this.Minezon92.saveOptional(lookupProvider));
            nbt.put("Minezon93", this.Minezon93.saveOptional(lookupProvider));
            nbt.put("Minezon94", this.Minezon94.saveOptional(lookupProvider));
            nbt.put("Minezon95", this.Minezon95.saveOptional(lookupProvider));
            nbt.put("Minezon96", this.Minezon96.saveOptional(lookupProvider));
            nbt.put("Minezon97", this.Minezon97.saveOptional(lookupProvider));
            nbt.put("Minezon98", this.Minezon98.saveOptional(lookupProvider));
            nbt.put("Minezon99", this.Minezon99.saveOptional(lookupProvider));
            nbt.put("Minezon100", this.Minezon100.saveOptional(lookupProvider));
            nbt.put("Minezon101", this.Minezon101.saveOptional(lookupProvider));
            nbt.put("Minezon102", this.Minezon102.saveOptional(lookupProvider));
            nbt.put("Minezon103", this.Minezon103.saveOptional(lookupProvider));
            nbt.put("Minezon104", this.Minezon104.saveOptional(lookupProvider));
            nbt.put("Minezon105", this.Minezon105.saveOptional(lookupProvider));
            nbt.put("Minezon106", this.Minezon106.saveOptional(lookupProvider));
            nbt.put("Minezon107", this.Minezon107.saveOptional(lookupProvider));
            nbt.put("Minezon108", this.Minezon108.saveOptional(lookupProvider));
            nbt.put("Minezon109", this.Minezon109.saveOptional(lookupProvider));
            nbt.put("Minezon110", this.Minezon110.saveOptional(lookupProvider));
            nbt.put("Minezon111", this.Minezon111.saveOptional(lookupProvider));
            nbt.put("Minezon112", this.Minezon112.saveOptional(lookupProvider));
            nbt.put("Minezon113", this.Minezon113.saveOptional(lookupProvider));
            nbt.put("Minezon114", this.Minezon114.saveOptional(lookupProvider));
            nbt.put("Minezon115", this.Minezon115.saveOptional(lookupProvider));
            nbt.put("Minezon116", this.Minezon116.saveOptional(lookupProvider));
            nbt.put("Minezon117", this.Minezon117.saveOptional(lookupProvider));
            nbt.put("Minezon118", this.Minezon118.saveOptional(lookupProvider));
            nbt.put("Minezon119", this.Minezon119.saveOptional(lookupProvider));
            nbt.put("Minezon120", this.Minezon120.saveOptional(lookupProvider));
            nbt.put("Minezon121", this.Minezon121.saveOptional(lookupProvider));
            nbt.put("Minezon122", this.Minezon122.saveOptional(lookupProvider));
            nbt.put("Minezon123", this.Minezon123.saveOptional(lookupProvider));
            nbt.put("Minezon124", this.Minezon124.saveOptional(lookupProvider));
            nbt.put("Minezon125", this.Minezon125.saveOptional(lookupProvider));
            nbt.put("Minezon126", this.Minezon126.saveOptional(lookupProvider));
            nbt.put("Minezon127", this.Minezon127.saveOptional(lookupProvider));
            nbt.put("Minezon128", this.Minezon128.saveOptional(lookupProvider));
            nbt.put("Minezon129", this.Minezon129.saveOptional(lookupProvider));
            nbt.put("Minezon130", this.Minezon130.saveOptional(lookupProvider));
            nbt.put("Minezon131", this.Minezon131.saveOptional(lookupProvider));
            nbt.put("Minezon132", this.Minezon132.saveOptional(lookupProvider));
            nbt.put("Minezon133", this.Minezon133.saveOptional(lookupProvider));
            nbt.put("Minezon134", this.Minezon134.saveOptional(lookupProvider));
            nbt.put("Minezon135", this.Minezon135.saveOptional(lookupProvider));
            nbt.put("Minezon136", this.Minezon136.saveOptional(lookupProvider));
            nbt.put("Minezon137", this.Minezon137.saveOptional(lookupProvider));
            nbt.put("Minezon138", this.Minezon138.saveOptional(lookupProvider));
            nbt.put("Minezon139", this.Minezon139.saveOptional(lookupProvider));
            nbt.put("Minezon140", this.Minezon140.saveOptional(lookupProvider));
            nbt.put("Minezon141", this.Minezon141.saveOptional(lookupProvider));
            nbt.put("Minezon142", this.Minezon142.saveOptional(lookupProvider));
            nbt.put("Minezon143", this.Minezon143.saveOptional(lookupProvider));
            nbt.put("Minezon144", this.Minezon144.saveOptional(lookupProvider));
            nbt.put("Minezon145", this.Minezon145.saveOptional(lookupProvider));
            nbt.put("Minezon146", this.Minezon146.saveOptional(lookupProvider));
            nbt.put("Minezon147", this.Minezon147.saveOptional(lookupProvider));
            nbt.put("Minezon148", this.Minezon148.saveOptional(lookupProvider));
            nbt.put("Minezon149", this.Minezon149.saveOptional(lookupProvider));
            nbt.put("Minezon150", this.Minezon150.saveOptional(lookupProvider));
            nbt.put("Minezon151", this.Minezon151.saveOptional(lookupProvider));
            nbt.put("Minezon152", this.Minezon152.saveOptional(lookupProvider));
            nbt.put("Minezon153", this.Minezon153.saveOptional(lookupProvider));
            nbt.put("Minezon154", this.Minezon154.saveOptional(lookupProvider));
            nbt.put("Minezon155", this.Minezon155.saveOptional(lookupProvider));
            nbt.put("Minezon156", this.Minezon156.saveOptional(lookupProvider));
            nbt.put("Minezon157", this.Minezon157.saveOptional(lookupProvider));
            nbt.put("Minezon158", this.Minezon158.saveOptional(lookupProvider));
            nbt.put("Minezon159", this.Minezon159.saveOptional(lookupProvider));
            nbt.put("Minezon160", this.Minezon160.saveOptional(lookupProvider));
            nbt.put("Minezon161", this.Minezon161.saveOptional(lookupProvider));
            nbt.put("Minezon162", this.Minezon162.saveOptional(lookupProvider));
            nbt.put("Minezon163", this.Minezon163.saveOptional(lookupProvider));
            nbt.put("Minezon164", this.Minezon164.saveOptional(lookupProvider));
            nbt.put("Minezon165", this.Minezon165.saveOptional(lookupProvider));
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "supermod_worldvars";
        boolean _syncDirty = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }
}

