/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.model.ModelIndex;
import cn.solarmoon.spark_core.util.SparkMathKt;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcn/solarmoon/spark_core/animation/IBlockEntityAnimatable;", "B", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "defaultModelIndex", "Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "getDefaultModelIndex", "()Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "getWorldPositionMatrix", "Lorg/joml/Matrix4f;", "partialTicks", "", "animLevel", "Lnet/minecraft/world/level/Level;", "getAnimLevel", "()Lnet/minecraft/world/level/Level;", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nIBlockEntityAnimatable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IBlockEntityAnimatable.kt\ncn/solarmoon/spark_core/animation/IBlockEntityAnimatable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,24:1\n1#2:25\n*E\n"})
public interface IBlockEntityAnimatable<B extends BlockEntity>
extends IAnimatable<B> {
    @Override
    @NotNull
    default public ModelIndex getDefaultModelIndex() {
        BlockEntityType blockEntityType = ((BlockEntity)this.getAnimatable()).getType();
        Intrinsics.checkNotNullExpressionValue((Object)blockEntityType, (String)"getType(...)");
        return ModelIndex.Companion.of(blockEntityType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    default public Matrix4f getWorldPositionMatrix(@NotNull Number partialTicks) {
        void it;
        Optional optional;
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Matrix4f matrix4f = new Matrix4f();
        BlockPos blockPos = ((BlockEntity)this.getAnimatable()).getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Optional optional2 = optional = ((BlockEntity)this.getAnimatable()).getBlockState().getOptionalValue((Property)BlockStateProperties.FACING);
        Matrix4f matrix4f2 = matrix4f.translate((Vector3fc)SparkMathKt.toVector3f(blockPos).add(0.5f, 0.0f, 0.5f));
        boolean bl = false;
        boolean bl2 = it.isPresent();
        Optional optional3 = bl2 ? optional : null;
        if (optional3 == null || (optional3 = (Direction)optional3.get()) == null || (optional3 = optional3.getRotation()) == null) {
            optional3 = new Quaternionf();
        }
        Matrix4f matrix4f3 = matrix4f2.rotate((Quaternionfc)optional3);
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f3, (String)"rotate(...)");
        return matrix4f3;
    }

    @Override
    @Nullable
    default public Level getAnimLevel() {
        return ((BlockEntity)this.getAnimatable()).getLevel();
    }
}

