/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation;

import cn.solarmoon.spark_core.animation.ItemAnimatable;
import cn.solarmoon.spark_core.animation.model.ModelIndex;
import cn.solarmoon.spark_core.registry.common.SparkDataComponents;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\"\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0016J \u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcn/solarmoon/spark_core/animation/ICustomModelItem;", "", "getRenderInstance", "Lcn/solarmoon/spark_core/animation/ItemAnimatable;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "context", "Lnet/minecraft/world/item/ItemDisplayContext;", "getModelIndex", "Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "createItemAnimatable", "use2dModel", "", "displayContext", "getRenderOffset", "Lorg/joml/Vector3f;", "getRenderRotation", "getRenderScale", "getColor", "Ljava/awt/Color;", "SparkCore-1.21.1-neoforge"})
public interface ICustomModelItem {
    @Nullable
    default public ItemAnimatable getRenderInstance(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull ItemDisplayContext context) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ItemAnimatable animatable;
            HashMap customModels = (HashMap)itemStack.get((Supplier)SparkDataComponents.INSTANCE.getCUSTOM_ITEM_MODEL());
            if (customModels == null) {
                customModels = new HashMap();
            }
            if ((animatable = (ItemAnimatable)customModels.get(context)) == null || !Intrinsics.areEqual((Object)animatable.getItemStack(), (Object)itemStack) || animatable.getAnimLevel() != level) {
                animatable = this.createItemAnimatable(itemStack, level, context);
            }
            return animatable;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public ModelIndex getModelIndex(@NotNull ItemStack var1, @NotNull Level var2, @NotNull ItemDisplayContext var3);

    @Nullable
    default public ItemAnimatable createItemAnimatable(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull ItemDisplayContext context) {
        HashMap hashMap;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (itemStack.has((Supplier)SparkDataComponents.INSTANCE.getCUSTOM_ITEM_MODEL())) {
            Object object = itemStack.get((Supplier)SparkDataComponents.INSTANCE.getCUSTOM_ITEM_MODEL());
            Intrinsics.checkNotNull((Object)object);
            hashMap = (HashMap)object;
        } else {
            hashMap = new HashMap();
        }
        HashMap customModels = hashMap;
        ModelIndex modelIndex = this.getModelIndex(itemStack, level, context);
        ItemAnimatable animatable = new ItemAnimatable(itemStack, level);
        animatable.getModelController().setModel(modelIndex);
        ((Map)customModels).put(context, animatable);
        itemStack.set((Supplier)SparkDataComponents.INSTANCE.getCUSTOM_ITEM_MODEL(), (Object)customModels);
        return animatable;
    }

    default public boolean use2dModel(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull ItemDisplayContext displayContext) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)displayContext, (String)"displayContext");
        return true;
    }

    @NotNull
    default public Vector3f getRenderOffset(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull ItemDisplayContext displayContext) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)displayContext, (String)"displayContext");
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @NotNull
    default public Vector3f getRenderRotation(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull ItemDisplayContext displayContext) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)displayContext, (String)"displayContext");
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @NotNull
    default public Vector3f getRenderScale(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull ItemDisplayContext displayContext) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)displayContext, (String)"displayContext");
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    @NotNull
    default public Color getColor(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull ItemDisplayContext displayContext) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)displayContext, (String)"displayContext");
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        return color;
    }
}

