/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.model.ModelIndex;
import cn.solarmoon.spark_core.util.SparkMathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcn/solarmoon/spark_core/animation/IEntityAnimatable;", "T", "Lnet/minecraft/world/entity/Entity;", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "defaultModelIndex", "Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "getDefaultModelIndex", "()Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "getWorldPositionMatrix", "Lorg/joml/Matrix4f;", "partialTicks", "", "animLevel", "Lnet/minecraft/world/level/Level;", "getAnimLevel", "()Lnet/minecraft/world/level/Level;", "SparkCore-1.21.1-neoforge"})
public interface IEntityAnimatable<T extends Entity>
extends IAnimatable<T> {
    @Override
    @NotNull
    default public ModelIndex getDefaultModelIndex() {
        EntityType entityType = ((Entity)this.getAnimatable()).getType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
        return ModelIndex.Companion.of(entityType);
    }

    @Override
    @NotNull
    default public Matrix4f getWorldPositionMatrix(@NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Matrix4f matrix4f = new Matrix4f().translate((Vector3fc)((Entity)this.getAnimatable()).getPosition(partialTicks.floatValue()).toVector3f()).rotateY((float)Math.PI - SparkMathKt.toRadians(((Entity)this.getAnimatable()).getPreciseBodyRotation(partialTicks.floatValue())));
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"rotateY(...)");
        return matrix4f;
    }

    @Override
    @NotNull
    default public Level getAnimLevel() {
        Level level = ((Entity)this.getAnimatable()).level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return level;
    }
}

