/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.anim.AnimController;
import cn.solarmoon.spark_core.animation.model.ModelController;
import cn.solarmoon.spark_core.animation.model.ModelIndex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lcn/solarmoon/spark_core/animation/ItemAnimatable;", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "animLevel", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;)V", "getItemStack", "()Lnet/minecraft/world/item/ItemStack;", "getAnimLevel", "()Lnet/minecraft/world/level/Level;", "owner", "Lnet/minecraft/world/entity/Entity;", "getOwner", "()Lnet/minecraft/world/entity/Entity;", "setOwner", "(Lnet/minecraft/world/entity/Entity;)V", "animatable", "getAnimatable", "defaultModelIndex", "Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "getDefaultModelIndex", "()Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "animController", "Lcn/solarmoon/spark_core/animation/anim/AnimController;", "getAnimController", "()Lcn/solarmoon/spark_core/animation/anim/AnimController;", "modelController", "Lcn/solarmoon/spark_core/animation/model/ModelController;", "getModelController", "()Lcn/solarmoon/spark_core/animation/model/ModelController;", "physicsTick", "", "inventoryTick", "getWorldPositionMatrix", "Lorg/joml/Matrix4f;", "partialTicks", "", "SparkCore-1.21.1-neoforge"})
public class ItemAnimatable
implements IAnimatable<ItemStack> {
    @NotNull
    private final ItemStack itemStack;
    @NotNull
    private final Level animLevel;
    @Nullable
    private Entity owner;
    @NotNull
    private final ItemStack animatable;
    @NotNull
    private final AnimController animController;
    @NotNull
    private final ModelController modelController;

    public ItemAnimatable(@NotNull ItemStack itemStack, @NotNull Level animLevel) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)animLevel, (String)"animLevel");
        this.itemStack = itemStack;
        this.animLevel = animLevel;
        this.animatable = this.itemStack;
        this.animController = new AnimController(this);
        this.modelController = new ModelController(this);
    }

    @NotNull
    public final ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    @NotNull
    public Level getAnimLevel() {
        return this.animLevel;
    }

    @Nullable
    public final Entity getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nullable Entity entity) {
        this.owner = entity;
    }

    @Override
    @NotNull
    public ItemStack getAnimatable() {
        return this.animatable;
    }

    @Override
    @NotNull
    public ModelIndex getDefaultModelIndex() {
        Item item = this.itemStack.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
        return ModelIndex.Companion.of(item);
    }

    @Override
    @NotNull
    public AnimController getAnimController() {
        return this.animController;
    }

    @Override
    @NotNull
    public ModelController getModelController() {
        return this.modelController;
    }

    public void physicsTick() {
        this.getAnimController().physTick();
    }

    public void inventoryTick(@NotNull Entity owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!Intrinsics.areEqual((Object)this.owner, (Object)owner)) {
            this.owner = owner;
        }
    }

    @Override
    @NotNull
    public Matrix4f getWorldPositionMatrix(@NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Entity entity = this.owner;
        if (entity == null) {
            return new Matrix4f();
        }
        Entity owner = entity;
        Matrix4f matrix4f = new Matrix4f().translate((Vector3fc)owner.getPosition(partialTicks.floatValue()).toVector3f()).rotateY(owner.getViewYRot(partialTicks.floatValue()));
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"rotateY(...)");
        return matrix4f;
    }
}

