/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.anim;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.ItemAnimatable;
import cn.solarmoon.spark_core.event.BoneUpdateEvent;
import cn.solarmoon.spark_core.event.ItemStackInventoryTickEvent;
import cn.solarmoon.spark_core.event.PhysicsEntityTickEvent;
import cn.solarmoon.spark_core.registry.common.SparkCapabilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0003\u00a8\u0006\u0010"}, d2={"Lcn/solarmoon/spark_core/animation/anim/AnimApplier;", "", "<init>", "()V", "playerJoin", "", "event", "Lnet/neoforged/neoforge/event/entity/EntityJoinLevelEvent;", "physTick", "Lcn/solarmoon/spark_core/event/PhysicsEntityTickEvent;", "entityTick", "Lnet/neoforged/neoforge/event/tick/EntityTickEvent$Post;", "itemTick", "Lcn/solarmoon/spark_core/event/ItemStackInventoryTickEvent;", "onBoneUpdate", "Lcn/solarmoon/spark_core/event/BoneUpdateEvent;", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nAnimApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimApplier.kt\ncn/solarmoon/spark_core/animation/anim/AnimApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1869#2,2:66\n*S KotlinDebug\n*F\n+ 1 AnimApplier.kt\ncn/solarmoon/spark_core/animation/anim/AnimApplier\n*L\n33#1:66,2\n*E\n"})
public final class AnimApplier {
    @NotNull
    public static final AnimApplier INSTANCE = new AnimApplier();

    private AnimApplier() {
    }

    @SubscribeEvent
    private final void playerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player && ((Player)entity).isLocalPlayer() && entity instanceof LocalPlayer) {
            ((LocalPlayer)entity).getModelController().setTextureLocation(((LocalPlayer)entity).getSkin().texture());
        }
    }

    @SubscribeEvent
    private final void physTick(PhysicsEntityTickEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEntityAnimatable) {
            ((IEntityAnimatable)entity).getAnimController().physTick();
        }
        if (entity instanceof Player) {
            NonNullList nonNullList = ((Player)entity).getInventory().items;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
            Iterable $this$forEach$iv = (Iterable)nonNullList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                ItemAnimatable itemAnimatable = (ItemAnimatable)it.getCapability(SparkCapabilities.getITEM_ANIMATABLE(), (Object)((Player)entity).level());
                if (itemAnimatable != null) {
                    itemAnimatable.physicsTick();
                }
            }
        }
    }

    @SubscribeEvent
    private final void entityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEntityAnimatable) {
            ((IEntityAnimatable)entity).getAnimController().tick();
            if (entity.isSpectator()) {
                ((IEntityAnimatable)entity).getAnimController().stopAllAnimation();
            }
        }
        entity.setLastPosO(entity.position());
    }

    @SubscribeEvent
    private final void itemTick(ItemStackInventoryTickEvent event) {
        block0: {
            ItemAnimatable itemAnimatable;
            ItemStack stack = event.getStack();
            ItemAnimatable itemAnimatable2 = (ItemAnimatable)stack.getCapability(SparkCapabilities.getITEM_ANIMATABLE(), (Object)event.getEntity().level());
            if (itemAnimatable2 == null) break block0;
            ItemAnimatable $this$itemTick_u24lambda_u241 = itemAnimatable = itemAnimatable2;
            boolean bl = false;
            $this$itemTick_u24lambda_u241.inventoryTick(event.getEntity());
            $this$itemTick_u24lambda_u241.getAnimController().tick();
        }
    }

    @SubscribeEvent
    private final void onBoneUpdate(BoneUpdateEvent event) {
        IAnimatable<?> animatable = event.getModel().getAnimatable();
        animatable.onBoneUpdate(event);
    }
}

