/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.anim;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.anim.AnimInstance;
import cn.solarmoon.spark_core.animation.anim.AnimLayer;
import cn.solarmoon.spark_core.animation.anim.BlendMode;
import cn.solarmoon.spark_core.animation.anim.KeyAnimData;
import cn.solarmoon.spark_core.animation.anim.origin.OAnimationSet;
import cn.solarmoon.spark_core.animation.model.BonePose;
import cn.solarmoon.spark_core.animation.model.ModelIndex;
import cn.solarmoon.spark_core.animation.model.ModelInstance;
import cn.solarmoon.spark_core.animation.model.origin.OBone;
import cn.solarmoon.spark_core.animation.state.AnimStateMachine;
import cn.solarmoon.spark_core.animation.state.origin.OAnimStateMachine;
import cn.solarmoon.spark_core.animation.state.origin.OAnimStateMachineSet;
import cn.solarmoon.spark_core.util.SparkMathKt;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020!J\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020\u0012J\u0006\u00101\u001a\u00020)J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0018J\u0006\u00105\u001a\u00020)J\u0006\u00106\u001a\u00020)R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R'\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\u0015R\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010\"\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'\u00a8\u00067"}, d2={"Lcn/solarmoon/spark_core/animation/anim/AnimController;", "", "animatable", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "<init>", "(Lcn/solarmoon/spark_core/animation/IAnimatable;)V", "getAnimatable", "()Lcn/solarmoon/spark_core/animation/IAnimatable;", "originAnimations", "Lcn/solarmoon/spark_core/animation/anim/origin/OAnimationSet;", "getOriginAnimations", "()Lcn/solarmoon/spark_core/animation/anim/origin/OAnimationSet;", "originStateMachines", "Lcn/solarmoon/spark_core/animation/state/origin/OAnimStateMachineSet;", "getOriginStateMachines", "()Lcn/solarmoon/spark_core/animation/state/origin/OAnimStateMachineSet;", "layers", "", "", "Lcn/solarmoon/spark_core/animation/anim/AnimLayer;", "getLayers", "()Ljava/util/Map;", "stateMachines", "", "", "Lcn/solarmoon/spark_core/animation/state/AnimStateMachine;", "getStateMachines", "stateMachines$delegate", "Lkotlin/Lazy;", "value", "speedChangeTime", "getSpeedChangeTime", "()I", "", "overallSpeed", "getOverallSpeed", "()F", "isPlayingAnim", "", "()Z", "changeSpeed", "", "time", "speed", "playAnimation", "anim", "Lcn/solarmoon/spark_core/animation/anim/AnimInstance;", "stopAnimation", "group", "stopAllAnimation", "blendBone", "Lcn/solarmoon/spark_core/animation/anim/KeyAnimData;", "boneName", "physTick", "tick", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nAnimController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimController.kt\ncn/solarmoon/spark_core/animation/anim/AnimController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,108:1\n1761#2,3:109\n1869#2,2:119\n1869#2:121\n1869#2,2:122\n1870#2:124\n1056#2:125\n1869#2,2:126\n1869#2,2:136\n1252#2,4:140\n384#3,7:112\n465#3:138\n415#3:139\n216#4,2:128\n216#4,2:130\n216#4,2:132\n216#4,2:134\n*S KotlinDebug\n*F\n+ 1 AnimController.kt\ncn/solarmoon/spark_core/animation/anim/AnimController\n*L\n32#1:109,3\n47#1:119,2\n51#1:121\n52#1:122,2\n51#1:124\n60#1:125\n60#1:126,2\n105#1:136,2\n25#1:140,4\n43#1:112,7\n25#1:138\n25#1:139\n83#1:128,2\n86#1:130,2\n98#1:132,2\n103#1:134,2\n*E\n"})
public final class AnimController {
    @NotNull
    private final IAnimatable<?> animatable;
    @NotNull
    private final Map<Integer, AnimLayer> layers;
    @NotNull
    private final Lazy stateMachines$delegate;
    private int speedChangeTime;
    private float overallSpeed;

    public AnimController(@NotNull IAnimatable<?> animatable) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        this.animatable = animatable;
        this.layers = new LinkedHashMap();
        this.stateMachines$delegate = LazyKt.lazy(() -> AnimController.stateMachines_delegate$lambda$1(this));
        this.overallSpeed = 1.0f;
    }

    @NotNull
    public final IAnimatable<?> getAnimatable() {
        return this.animatable;
    }

    @NotNull
    public final OAnimationSet getOriginAnimations() {
        ModelInstance modelInstance = this.animatable.getModelController().getModel();
        return OAnimationSet.Companion.getOrEmpty(modelInstance != null ? modelInstance.getIndex() : null);
    }

    @NotNull
    public final OAnimStateMachineSet getOriginStateMachines() {
        Object object = this.animatable.getModelController().getModel();
        return OAnimStateMachineSet.Companion.getOrEmpty(object != null && (object = ((ModelInstance)object).getIndex()) != null ? ((ModelIndex)object).getLocation() : null);
    }

    @NotNull
    public final Map<Integer, AnimLayer> getLayers() {
        return this.layers;
    }

    @NotNull
    public final Map<String, AnimStateMachine> getStateMachines() {
        Lazy lazy = this.stateMachines$delegate;
        return (Map)lazy.getValue();
    }

    public final int getSpeedChangeTime() {
        return this.speedChangeTime;
    }

    public final float getOverallSpeed() {
        return this.overallSpeed;
    }

    public final boolean isPlayingAnim() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.layers.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AnimLayer it = (AnimLayer)element$iv;
                    boolean bl2 = false;
                    if (!it.isPlaying()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void changeSpeed(int time, float speed) {
        this.overallSpeed = speed;
        this.speedChangeTime = time;
    }

    /*
     * WARNING - void declaration
     */
    public final void playAnimation(@NotNull AnimInstance anim) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        Map<Integer, AnimLayer> map = this.layers;
        Integer key$iv = anim.getGroup();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            AnimLayer answer$iv = new AnimLayer();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((AnimLayer)object).getAnimations().add(anim);
    }

    public final void stopAnimation(int group) {
        block1: {
            Object object = this.layers.get(group);
            if (object == null || (object = ((AnimLayer)object).getAnimations()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnimInstance it = (AnimInstance)element$iv;
                boolean bl = false;
                it.exit();
            }
        }
    }

    public final void stopAllAnimation() {
        Iterable $this$forEach$iv = this.layers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimLayer it = (AnimLayer)element$iv;
            boolean bl = false;
            ConcurrentHashMap.KeySetView<AnimInstance, Boolean> keySetView = it.getAnimations();
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"<get-animations>(...)");
            Iterable $this$forEach$iv2 = keySetView;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AnimInstance it2 = (AnimInstance)element$iv2;
                boolean bl2 = false;
                it2.exit();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KeyAnimData blendBone(@NotNull String boneName) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)boneName, (String)"boneName");
        Vector3f pos = new Vector3f();
        Quaterniond rot = new Quaterniond();
        Vector3f scale = new Vector3f(1.0f);
        Iterable $this$sortedBy$iv = this.layers.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            AnimLayer layer = (AnimLayer)entry.getValue();
            if (!layer.isPlaying()) continue;
            KeyAnimData boneTransform = layer.blendBone(boneName);
            double weight = layer.getBoneWeight(boneName);
            if (weight == 0.0) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[layer.getBlendMode().ordinal()]) {
                case 1: {
                    pos.lerp((Vector3fc)boneTransform.getPosition().toVector3f(), (float)weight);
                    rot.slerp((Quaterniondc)new Quaterniond().rotateZYX(boneTransform.getRotation().z, boneTransform.getRotation().y, boneTransform.getRotation().x), weight);
                    Vector3f vector3f = scale.lerp((Vector3fc)boneTransform.getScale().toVector3f(), (float)weight);
                    break;
                }
                case 2: {
                    pos.add((Vector3fc)boneTransform.getPosition().toVector3f());
                    rot.mul((Quaterniondc)new Quaterniond().rotateZYX(boneTransform.getRotation().z, boneTransform.getRotation().y, boneTransform.getRotation().x));
                    Vec3 vec3 = new Vec3(1.0, 1.0, 1.0);
                    Vec3 vec32 = SparkMathKt.minus(boneTransform.getScale(), new Vec3(1.0, 1.0, 1.0)).multiply(new Vec3(weight, weight, weight));
                    Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"multiply(...)");
                    Vector3f vector3f = scale.mul((Vector3fc)SparkMathKt.plus(vec3, vec32).toVector3f());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return new KeyAnimData(SparkMathKt.toVec3(pos), SparkMathKt.toVec3(SparkMathKt.toEuler(rot)), SparkMathKt.toVec3(scale));
    }

    public final void physTick() {
        Map<Integer, AnimLayer> $this$forEach$iv = this.layers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, AnimLayer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, AnimLayer> element$iv;
            Map.Entry<Integer, AnimLayer> entry = element$iv = iterator.next();
            boolean bl = false;
            AnimLayer layer = entry.getValue();
            layer.physicsTick(this.overallSpeed);
        }
        ModelInstance modelInstance = this.animatable.getModelController().getModel();
        if (modelInstance != null) {
            ModelInstance model = modelInstance;
            boolean bl = false;
            Map $this$forEach$iv2 = model.getOrigin().getBones();
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                String boneName = (String)entry.getKey();
                OBone bone = (OBone)entry.getValue();
                BonePose bonePose = model.getPose().getBonePoseOrCreateEmpty(boneName);
                bonePose.updateInternal$SparkCore_1_21_1_neoforge(this.blendBone(boneName));
            }
        }
        if (this.speedChangeTime > 0) {
            int n = this.speedChangeTime;
            this.speedChangeTime = n + -1;
        } else {
            this.overallSpeed = 1.0f;
        }
    }

    public final void tick() {
        Object $this$forEach$iv;
        ModelInstance modelInstance = this.animatable.getModelController().getModel();
        if (modelInstance != null) {
            ModelInstance model = modelInstance;
            boolean bl = false;
            $this$forEach$iv = model.getOrigin().getBones();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl2 = false;
                model.getPose().getBonePoseOrCreateEmpty((String)it.getKey()).setChanged$SparkCore_1_21_1_neoforge();
            }
        }
        Object $this$forEach$iv2 = this.layers;
        boolean $i$f$forEach = false;
        for (Map.Entry<Integer, AnimLayer> element$iv : $this$forEach$iv2.entrySet()) {
            $this$forEach$iv = element$iv;
            boolean bl = false;
            AnimLayer layer = (AnimLayer)$this$forEach$iv.getValue();
            layer.tick();
        }
        $this$forEach$iv2 = this.getStateMachines().values();
        $i$f$forEach = false;
        Iterator<Map.Entry<Integer, AnimLayer>> iterator = $this$forEach$iv2.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, AnimLayer> element$iv = iterator.next();
            AnimStateMachine it = (AnimStateMachine)((Object)element$iv);
            boolean bl = false;
            it.tick();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Map stateMachines_delegate$lambda$1(AnimController this$0) {
        void $this$mapValuesTo$iv$iv;
        Map<String, OAnimStateMachine> $this$mapValues$iv = this$0.getOriginStateMachines().getAnimationControllers();
        boolean $i$f$mapValues = false;
        Map<String, OAnimStateMachine> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            AnimStateMachine animStateMachine = ((OAnimStateMachine)it.getValue()).build(this$0.animatable);
            map3.put(k, animStateMachine);
        }
        return destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlendMode.values().length];
            try {
                nArray[BlendMode.OVERRIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.ADDITIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

