/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.anim;

import cn.solarmoon.spark_core.animation.anim.AnimInstance;
import cn.solarmoon.spark_core.animation.anim.AnimState;
import cn.solarmoon.spark_core.animation.anim.BlendMode;
import cn.solarmoon.spark_core.animation.anim.KeyAnimData;
import cn.solarmoon.spark_core.animation.anim.origin.OBoneAnimation;
import cn.solarmoon.spark_core.util.SparkMathKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u001bRS\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcn/solarmoon/spark_core/animation/anim/AnimLayer;", "", "<init>", "()V", "animations", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lcn/solarmoon/spark_core/animation/anim/AnimInstance;", "kotlin.jvm.PlatformType", "", "getAnimations", "()Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "blendMode", "Lcn/solarmoon/spark_core/animation/anim/BlendMode;", "getBlendMode", "()Lcn/solarmoon/spark_core/animation/anim/BlendMode;", "setBlendMode", "(Lcn/solarmoon/spark_core/animation/anim/BlendMode;)V", "getBoneWeight", "", "boneName", "", "isPlaying", "()Z", "blendBone", "Lcn/solarmoon/spark_core/animation/anim/KeyAnimData;", "physicsTick", "", "overallSpeed", "tick", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nAnimLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimLayer.kt\ncn/solarmoon/spark_core/animation/anim/AnimLayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1740#2,3:72\n1869#2,2:76\n1869#2,2:78\n1869#2,2:80\n1#3:75\n*S KotlinDebug\n*F\n+ 1 AnimLayer.kt\ncn/solarmoon/spark_core/animation/anim/AnimLayer\n*L\n17#1:72,3\n35#1:76,2\n58#1:78,2\n66#1:80,2\n*E\n"})
public final class AnimLayer {
    private final ConcurrentHashMap.KeySetView<AnimInstance, Boolean> animations = ConcurrentHashMap.newKeySet();
    @NotNull
    private BlendMode blendMode = BlendMode.OVERRIDE;

    public final ConcurrentHashMap.KeySetView<AnimInstance, Boolean> getAnimations() {
        return this.animations;
    }

    @NotNull
    public final BlendMode getBlendMode() {
        return this.blendMode;
    }

    public final void setBlendMode(@NotNull BlendMode blendMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)blendMode), (String)"<set-?>");
        this.blendMode = blendMode;
    }

    public final float getBoneWeight(@NotNull String boneName) {
        float f;
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)boneName, (String)"boneName");
            ConcurrentHashMap.KeySetView<AnimInstance, Boolean> keySetView = this.animations;
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"animations");
            Iterable $this$all$iv = keySetView;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AnimInstance it = (AnimInstance)element$iv;
                    boolean bl2 = false;
                    if (!((Map)it.getOrigin().getBones()).containsKey(boneName)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return 0.0f;
        }
        if (this.animations.size() == 1) {
            ConcurrentHashMap.KeySetView<AnimInstance, Boolean> keySetView = this.animations;
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"animations");
            Iterator iterator = ((Iterable)keySetView).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            AnimInstance it = (AnimInstance)iterator.next();
            boolean bl3 = false;
            float f2 = it.getCurrentWeight();
            while (iterator.hasNext()) {
                AnimInstance it2 = (AnimInstance)iterator.next();
                $i$a$-maxOf-AnimLayer$getBoneWeight$2 = false;
                float f3 = it2.getCurrentWeight();
                f2 = Math.max(f2, f3);
            }
            f = f2;
        } else {
            f = 1.0f;
        }
        return f;
    }

    public final boolean isPlaying() {
        ConcurrentHashMap.KeySetView<AnimInstance, Boolean> keySetView = this.animations;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"animations");
        return !((Collection)keySetView).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KeyAnimData blendBone(@NotNull String boneName) {
        Intrinsics.checkNotNullParameter((Object)boneName, (String)"boneName");
        ConcurrentHashMap.KeySetView<AnimInstance, Boolean> keySetView = this.animations;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"animations");
        Iterable iterable = keySetView;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            AnimInstance animInstance = (AnimInstance)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getCurrentWeight();
            d = d2 + d3;
        }
        double totalWeight = d;
        Quaternionf boneBaseRot = new Quaternionf();
        if (totalWeight <= 0.0) {
            return new KeyAnimData(null, null, null, 7, null);
        }
        Vector3f pos = new Vector3f();
        Quaternionf rot = boneBaseRot;
        float accumulatedWeight = 0.0f;
        Vector3f scale = new Vector3f(1.0f);
        ConcurrentHashMap.KeySetView<AnimInstance, Boolean> keySetView2 = this.animations;
        Intrinsics.checkNotNullExpressionValue(keySetView2, (String)"animations");
        Iterable $this$forEach$iv = keySetView2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OBoneAnimation boneData;
            AnimInstance it = (AnimInstance)element$iv;
            boolean bl = false;
            if (it.getOrigin().getBoneAnimation(boneName) == null) continue;
            float pt = (float)((double)it.getCurrentWeight() / totalWeight);
            float time = it.getTypedTime();
            Intrinsics.checkNotNull((Object)it);
            pos.add((Vector3fc)boneData.getAnimPosAt(time, it).mul(pt));
            scale.add((Vector3fc)boneData.getAnimScaleAt(time, it).mul(pt)).sub((Vector3fc)new Vector3f(pt));
            Quaternionf origRot = SparkMathKt.toQuaternionf(boneData.getAnimRotAt(time, it));
            if (accumulatedWeight == 0.0f) {
                rot.set((Quaternionfc)origRot);
                accumulatedWeight = pt;
                continue;
            }
            float t = pt / (accumulatedWeight + pt);
            rot.slerp((Quaternionfc)origRot, t);
            accumulatedWeight += pt;
        }
        Vec3 vec3 = SparkMathKt.toVec3(pos);
        Vector3f vector3f = rot.getEulerAnglesXYZ(new Vector3f());
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"getEulerAnglesXYZ(...)");
        return new KeyAnimData(vec3, SparkMathKt.toVec3(vector3f), SparkMathKt.toVec3(scale));
    }

    public final void physicsTick(float overallSpeed) {
        ConcurrentHashMap.KeySetView<AnimInstance, Boolean> keySetView = this.animations;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"animations");
        Iterable $this$forEach$iv = keySetView;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimInstance it = (AnimInstance)element$iv;
            boolean bl = false;
            it.physTick(overallSpeed);
        }
        this.animations.removeIf(arg_0 -> AnimLayer.physicsTick$lambda$6(AnimLayer::physicsTick$lambda$5, arg_0));
    }

    public final void tick() {
        ConcurrentHashMap.KeySetView<AnimInstance, Boolean> keySetView = this.animations;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"animations");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)keySetView);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimInstance it = (AnimInstance)element$iv;
            boolean bl = false;
            it.tick();
        }
    }

    private static final boolean physicsTick$lambda$5(AnimInstance it) {
        return it.getState() == AnimState.IDLE;
    }

    private static final boolean physicsTick$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

