/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.anim;

import cn.solarmoon.spark_core.util.SparkMathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcn/solarmoon/spark_core/animation/anim/KeyAnimData;", "", "position", "Lnet/minecraft/world/phys/Vec3;", "rotation", "scale", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)V", "getPosition", "()Lnet/minecraft/world/phys/Vec3;", "getRotation", "getScale", "lerp", "target", "progress", "", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "copy", "toString", "", "SparkCore-1.21.1-neoforge"})
public final class KeyAnimData {
    @NotNull
    private final Vec3 position;
    @NotNull
    private final Vec3 rotation;
    @NotNull
    private final Vec3 scale;

    public KeyAnimData(@NotNull Vec3 position, @NotNull Vec3 rotation, @NotNull Vec3 scale) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
    }

    public /* synthetic */ KeyAnimData(Vec3 vec3, Vec3 vec32, Vec3 vec33, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vec3 = Vec3.ZERO;
        }
        if ((n & 2) != 0) {
            vec32 = Vec3.ZERO;
        }
        if ((n & 4) != 0) {
            vec33 = new Vec3(1.0, 1.0, 1.0);
        }
        this(vec3, vec32, vec33);
    }

    @NotNull
    public final Vec3 getPosition() {
        return this.position;
    }

    @NotNull
    public final Vec3 getRotation() {
        return this.rotation;
    }

    @NotNull
    public final Vec3 getScale() {
        return this.scale;
    }

    @NotNull
    public final KeyAnimData lerp(@NotNull KeyAnimData target, double progress) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Vec3 vec3 = this.position.lerp(target.position, progress);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"lerp(...)");
        Vec3 vec32 = SparkMathKt.rotLerp(this.rotation, target.rotation, progress);
        Vec3 vec33 = this.scale.lerp(target.scale, progress);
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"lerp(...)");
        return new KeyAnimData(vec3, vec32, vec33);
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        Object object = other;
        if (object != null) {
            Object it = object;
            boolean bl2 = false;
            bl = it instanceof KeyAnimData && Intrinsics.areEqual((Object)this.position, (Object)((KeyAnimData)it).position) && Intrinsics.areEqual((Object)this.rotation, (Object)((KeyAnimData)it).rotation) && Intrinsics.areEqual((Object)this.scale, (Object)((KeyAnimData)it).scale);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.position.hashCode();
        result = 31 * result + this.rotation.hashCode();
        result = 31 * result + this.scale.hashCode();
        return result;
    }

    @NotNull
    public final Vec3 component1() {
        return this.position;
    }

    @NotNull
    public final Vec3 component2() {
        return this.rotation;
    }

    @NotNull
    public final Vec3 component3() {
        return this.scale;
    }

    @NotNull
    public final KeyAnimData copy(@NotNull Vec3 position, @NotNull Vec3 rotation, @NotNull Vec3 scale) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return new KeyAnimData(position, rotation, scale);
    }

    public static /* synthetic */ KeyAnimData copy$default(KeyAnimData keyAnimData, Vec3 vec3, Vec3 vec32, Vec3 vec33, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = keyAnimData.position;
        }
        if ((n & 2) != 0) {
            vec32 = keyAnimData.rotation;
        }
        if ((n & 4) != 0) {
            vec33 = keyAnimData.scale;
        }
        return keyAnimData.copy(vec3, vec32, vec33);
    }

    @NotNull
    public String toString() {
        return "KeyAnimData(position=" + this.position + ", rotation=" + this.rotation + ", scale=" + this.scale + ")";
    }

    public KeyAnimData() {
        this(null, null, null, 7, null);
    }
}

