/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.anim.origin;

import cn.solarmoon.spark_core.animation.anim.AnimInstance;
import cn.solarmoon.spark_core.animation.anim.origin.OKeyFrame;
import cn.solarmoon.spark_core.util.SparkMathKt;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\"\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0013"}, d2={"Lcn/solarmoon/spark_core/animation/anim/origin/InterpolationType;", "", "<init>", "(Ljava/lang/String;I)V", "LINEAR", "CATMULLROM", "lerp", "Lorg/joml/Vector3f;", "progress", "", "keyFrames", "Ljava/util/LinkedHashMap;", "Lcn/solarmoon/spark_core/animation/anim/origin/OKeyFrame;", "Lkotlin/collections/LinkedHashMap;", "presentIndex", "", "anim", "Lcn/solarmoon/spark_core/animation/anim/AnimInstance;", "Companion", "SparkCore-1.21.1-neoforge"})
public final class InterpolationType
extends Enum<InterpolationType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Codec<InterpolationType> CODEC;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, InterpolationType> STREAM_CODEC;
    public static final /* enum */ InterpolationType LINEAR;
    public static final /* enum */ InterpolationType CATMULLROM;
    private static final /* synthetic */ InterpolationType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    @NotNull
    public final Vector3f lerp(float progress, @NotNull LinkedHashMap<Float, OKeyFrame> keyFrames, int presentIndex, @NotNull AnimInstance anim) {
        Intrinsics.checkNotNullParameter(keyFrames, (String)"keyFrames");
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        float progress2 = Math.min(progress, 1.0f);
        Collection<OKeyFrame> collection = keyFrames.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<OKeyFrame> keyFrameGroup = collection;
        Vector3f kPre = ((OKeyFrame)CollectionsKt.elementAt((Iterable)keyFrameGroup, (int)Math.max(presentIndex - 1, 0))).getPre().eval(anim);
        Vector3f kNow = ((OKeyFrame)CollectionsKt.elementAt((Iterable)keyFrameGroup, (int)presentIndex)).getPost().eval(anim);
        Vector3f kTarget = ((OKeyFrame)CollectionsKt.elementAt((Iterable)keyFrameGroup, (int)Math.min(presentIndex + 1, keyFrameGroup.size() - 1))).getPre().eval(anim);
        Vector3f kPost = ((OKeyFrame)CollectionsKt.elementAt((Iterable)keyFrameGroup, (int)Math.min(presentIndex + 2, keyFrameGroup.size() - 1))).getPost().eval(anim);
        if (presentIndex == keyFrameGroup.size() - 1) {
            return kNow;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                double x = Mth.lerp((double)progress2, (double)kNow.x, (double)kTarget.x);
                double y = Mth.lerp((double)progress2, (double)kNow.y, (double)kTarget.y);
                double z = Mth.lerp((double)progress2, (double)kNow.z, (double)kTarget.z);
                return SparkMathKt.toVector3f(new Vector3d(x, y, z));
            }
            case 2: {
                float x = Mth.catmullrom((float)progress2, (float)kPre.x, (float)kNow.x, (float)kTarget.x, (float)kPost.x);
                float y = Mth.catmullrom((float)progress2, (float)kPre.y, (float)kNow.y, (float)kTarget.y, (float)kPost.y);
                float z = Mth.catmullrom((float)progress2, (float)kPre.z, (float)kNow.z, (float)kTarget.z, (float)kPost.z);
                return new Vector3f(x, y, z);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static InterpolationType[] values() {
        return (InterpolationType[])$VALUES.clone();
    }

    public static InterpolationType valueOf(String value) {
        return Enum.valueOf(InterpolationType.class, value);
    }

    @NotNull
    public static EnumEntries<InterpolationType> getEntries() {
        return $ENTRIES;
    }

    private static final InterpolationType CODEC$lambda$0(String name) {
        Intrinsics.checkNotNull((Object)name);
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return InterpolationType.valueOf(string);
    }

    private static final InterpolationType CODEC$lambda$1(Function1 $tmp0, Object p0) {
        return (InterpolationType)((Object)$tmp0.invoke(p0));
    }

    private static final String CODEC$lambda$2(InterpolationType type) {
        String string = type.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final String CODEC$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @NotNull
    public static final Codec<InterpolationType> getCODEC() {
        return Companion.getCODEC();
    }

    @NotNull
    public static final StreamCodec<FriendlyByteBuf, InterpolationType> getSTREAM_CODEC() {
        return Companion.getSTREAM_CODEC();
    }

    static {
        LINEAR = new InterpolationType();
        CATMULLROM = new InterpolationType();
        $VALUES = interpolationTypeArray = new InterpolationType[]{InterpolationType.LINEAR, InterpolationType.CATMULLROM};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        Codec codec2 = Codec.STRING.xmap(arg_0 -> InterpolationType.CODEC$lambda$1(InterpolationType::CODEC$lambda$0, arg_0), arg_0 -> InterpolationType.CODEC$lambda$3(InterpolationType::CODEC$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"xmap(...)");
        CODEC = codec2;
        STREAM_CODEC = (StreamCodec)new StreamCodec<FriendlyByteBuf, InterpolationType>(){

            public InterpolationType decode(FriendlyByteBuf buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                Enum enum_ = buffer.readEnum(InterpolationType.class);
                Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
                return (InterpolationType)enum_;
            }

            public void encode(FriendlyByteBuf buffer, InterpolationType value) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                buffer.writeEnum((Enum)value);
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcn/solarmoon/spark_core/animation/anim/origin/InterpolationType$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lcn/solarmoon/spark_core/animation/anim/origin/InterpolationType;", "getCODEC$annotations", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "getSTREAM_CODEC$annotations", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<InterpolationType> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCODEC$annotations() {
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, InterpolationType> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getSTREAM_CODEC$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InterpolationType.values().length];
            try {
                nArray[InterpolationType.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InterpolationType.CATMULLROM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

