/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.model;

import cn.solarmoon.spark_core.animation.anim.KeyAnimData;
import cn.solarmoon.spark_core.animation.model.ModelInstance;
import cn.solarmoon.spark_core.animation.model.origin.OBone;
import cn.solarmoon.spark_core.event.BoneUpdateEvent;
import cn.solarmoon.spark_core.util.SparkMathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u001d\u0010\u001d\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020\u001aJ\u0010\u0010#\u001a\u00020 2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u00172\b\b\u0002\u0010\"\u001a\u00020\u001aJ\u0010\u0010'\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020\u001aJ\u0010\u0010(\u001a\u00020 2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010)\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010*\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcn/solarmoon/spark_core/animation/model/BonePose;", "", "model", "Lcn/solarmoon/spark_core/animation/model/ModelInstance;", "name", "", "<init>", "(Lcn/solarmoon/spark_core/animation/model/ModelInstance;Ljava/lang/String;)V", "getModel", "()Lcn/solarmoon/spark_core/animation/model/ModelInstance;", "getName", "()Ljava/lang/String;", "internalTransform", "Lcn/solarmoon/spark_core/animation/anim/KeyAnimData;", "oLocalTransform", "localTransform", "updateInternal", "", "newData", "updateInternal$SparkCore_1_21_1_neoforge", "setChanged", "setChanged$SparkCore_1_21_1_neoforge", "getLocalPosition", "Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "partialTicks", "", "(Ljava/lang/Number;)Lnet/minecraft/world/phys/Vec3;", "getLocalRotation", "getLocalScale", "getLocalTransform", "getLocalTransformMatrix", "Lorg/joml/Matrix4f;", "getSpaceBoneMatrix", "partialTick", "getSpaceBonePivotMatrix", "getSpaceBonePivot", "Lorg/joml/Vector3f;", "offset", "getWorldBoneMatrix", "getWorldBonePivotMatrix", "getWorldBonePivot", "copy", "SparkCore-1.21.1-neoforge"})
public final class BonePose {
    @NotNull
    private final ModelInstance model;
    @NotNull
    private final String name;
    @NotNull
    private KeyAnimData internalTransform;
    @NotNull
    private KeyAnimData oLocalTransform;
    @NotNull
    private KeyAnimData localTransform;

    public BonePose(@NotNull ModelInstance model, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.model = model;
        this.name = name;
        this.internalTransform = new KeyAnimData(null, null, null, 7, null);
        this.oLocalTransform = new KeyAnimData(null, null, null, 7, null);
        this.localTransform = new KeyAnimData(null, null, null, 7, null);
    }

    @NotNull
    public final ModelInstance getModel() {
        return this.model;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void updateInternal$SparkCore_1_21_1_neoforge(@NotNull KeyAnimData newData) {
        Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
        this.internalTransform = newData;
    }

    public final void setChanged$SparkCore_1_21_1_neoforge() {
        BoneUpdateEvent event = (BoneUpdateEvent)NeoForge.EVENT_BUS.post((Event)new BoneUpdateEvent(this.model, this, this.localTransform, this.internalTransform));
        this.oLocalTransform = event.getOldTransform();
        this.localTransform = event.getNewTransform();
    }

    public final Vec3 getLocalPosition(@NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        return this.oLocalTransform.getPosition().lerp(this.localTransform.getPosition(), partialTicks.doubleValue());
    }

    public static /* synthetic */ Vec3 getLocalPosition$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = 1.0;
        }
        return bonePose.getLocalPosition(number);
    }

    @NotNull
    public final Vec3 getLocalRotation(@NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        return SparkMathKt.rotLerp(this.oLocalTransform.getRotation(), this.localTransform.getRotation(), partialTicks.doubleValue());
    }

    public static /* synthetic */ Vec3 getLocalRotation$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = 1.0;
        }
        return bonePose.getLocalRotation(number);
    }

    public final Vec3 getLocalScale(@NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        return this.oLocalTransform.getScale().lerp(this.localTransform.getScale(), partialTicks.doubleValue());
    }

    public static /* synthetic */ Vec3 getLocalScale$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = 1.0;
        }
        return bonePose.getLocalScale(number);
    }

    @NotNull
    public final KeyAnimData getLocalTransform(@NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        return this.oLocalTransform.lerp(this.localTransform, partialTicks.doubleValue());
    }

    public static /* synthetic */ KeyAnimData getLocalTransform$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = 1.0;
        }
        return bonePose.getLocalTransform(number);
    }

    @NotNull
    public final Matrix4f getLocalTransformMatrix(@NotNull Number partialTicks) {
        Matrix4f matrix4f;
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Matrix4f $this$getLocalTransformMatrix_u24lambda_u240 = matrix4f = new Matrix4f();
        boolean bl = false;
        OBone oBone = this.model.getOrigin().getBone(this.name);
        if (oBone != null) {
            OBone bone = oBone;
            $this$getLocalTransformMatrix_u24lambda_u240.translate((Vector3fc)bone.getPivot().toVector3f());
            $this$getLocalTransformMatrix_u24lambda_u240.translate((Vector3fc)this.getLocalPosition(partialTicks).toVector3f());
            $this$getLocalTransformMatrix_u24lambda_u240.rotateZYX(this.getLocalRotation(partialTicks).add(bone.getRotation()).toVector3f());
            $this$getLocalTransformMatrix_u24lambda_u240.scale((Vector3fc)this.getLocalScale(partialTicks).toVector3f());
            $this$getLocalTransformMatrix_u24lambda_u240.translate((Vector3fc)bone.getPivot().toVector3f().negate());
        }
        return matrix4f;
    }

    public static /* synthetic */ Matrix4f getLocalTransformMatrix$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = 1.0;
        }
        return bonePose.getLocalTransformMatrix(number);
    }

    @NotNull
    public final Matrix4f getSpaceBoneMatrix(@NotNull Number partialTick) {
        Matrix4f ma;
        block0: {
            OBone bone;
            Intrinsics.checkNotNullParameter((Object)partialTick, (String)"partialTick");
            ma = new Matrix4f();
            OBone oBone = bone = this.model.getOrigin().getBone(this.name);
            if (oBone == null) break block0;
            oBone.applyTransformWithParents(this.model.getPose(), ma, partialTick.floatValue());
        }
        return ma;
    }

    public static /* synthetic */ Matrix4f getSpaceBoneMatrix$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = Float.valueOf(1.0f);
        }
        return bonePose.getSpaceBoneMatrix(number);
    }

    @NotNull
    public final Matrix4f getSpaceBonePivotMatrix(@NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Matrix4f ma = this.getSpaceBoneMatrix(partialTicks);
        OBone oBone = this.model.getOrigin().getBone(this.name);
        if (oBone == null) {
            return ma;
        }
        OBone bone = oBone;
        ma.translate((Vector3fc)bone.getPivot().toVector3f());
        return ma;
    }

    public static /* synthetic */ Matrix4f getSpaceBonePivotMatrix$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = Float.valueOf(1.0f);
        }
        return bonePose.getSpaceBonePivotMatrix(number);
    }

    @NotNull
    public final Vector3f getSpaceBonePivot(@NotNull Vec3 offset, @NotNull Number partialTick) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)partialTick, (String)"partialTick");
        OBone oBone = this.model.getOrigin().getBone(this.name);
        if (oBone == null) {
            return new Vector3f();
        }
        OBone bone = oBone;
        Matrix4f spaceMatrix = this.getSpaceBoneMatrix(partialTick);
        Vector3f vector3f = spaceMatrix.transformPosition(bone.getPivot().add(offset).toVector3f());
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"transformPosition(...)");
        return vector3f;
    }

    public static /* synthetic */ Vector3f getSpaceBonePivot$default(BonePose bonePose, Vec3 vec3, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = Vec3.ZERO;
        }
        if ((n & 2) != 0) {
            number = Float.valueOf(1.0f);
        }
        return bonePose.getSpaceBonePivot(vec3, number);
    }

    @NotNull
    public final Matrix4f getWorldBoneMatrix(@NotNull Number partialTick) {
        Intrinsics.checkNotNullParameter((Object)partialTick, (String)"partialTick");
        Matrix4f ma = this.model.getAnimatable().getWorldPositionMatrix(Float.valueOf(partialTick.floatValue()));
        Matrix4f matrix4f = ma.mul((Matrix4fc)this.getSpaceBoneMatrix(partialTick));
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"mul(...)");
        return matrix4f;
    }

    public static /* synthetic */ Matrix4f getWorldBoneMatrix$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = Float.valueOf(1.0f);
        }
        return bonePose.getWorldBoneMatrix(number);
    }

    @NotNull
    public final Matrix4f getWorldBonePivotMatrix(@NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Matrix4f matrix4f = this.model.getAnimatable().getWorldPositionMatrix(Float.valueOf(partialTicks.floatValue())).mul((Matrix4fc)this.getSpaceBonePivotMatrix(partialTicks));
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"mul(...)");
        return matrix4f;
    }

    public static /* synthetic */ Matrix4f getWorldBonePivotMatrix$default(BonePose bonePose, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = Float.valueOf(1.0f);
        }
        return bonePose.getWorldBonePivotMatrix(number);
    }

    @NotNull
    public final Vector3f getWorldBonePivot(@NotNull Vec3 offset, @NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Vector3f vector3f = this.model.getAnimatable().getWorldPositionMatrix(Float.valueOf(partialTicks.floatValue())).transformPosition(this.getSpaceBonePivot(offset, partialTicks));
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"transformPosition(...)");
        return vector3f;
    }

    public static /* synthetic */ Vector3f getWorldBonePivot$default(BonePose bonePose, Vec3 vec3, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = Vec3.ZERO;
        }
        if ((n & 2) != 0) {
            number = Float.valueOf(1.0f);
        }
        return bonePose.getWorldBonePivot(vec3, number);
    }

    @NotNull
    public final BonePose copy() {
        BonePose bonePose;
        BonePose $this$copy_u24lambda_u241 = bonePose = new BonePose(this.model, this.name);
        boolean bl = false;
        $this$copy_u24lambda_u241.internalTransform = this.internalTransform;
        $this$copy_u24lambda_u241.oLocalTransform = this.oLocalTransform;
        $this$copy_u24lambda_u241.localTransform = this.localTransform;
        return bonePose;
    }
}

