/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.model;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.model.ModelIndex;
import cn.solarmoon.spark_core.animation.model.ModelInstance;
import cn.solarmoon.spark_core.animation.model.origin.OModel;
import cn.solarmoon.spark_core.event.ModelChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcn/solarmoon/spark_core/animation/model/ModelController;", "", "animatable", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "<init>", "(Lcn/solarmoon/spark_core/animation/IAnimatable;)V", "getAnimatable", "()Lcn/solarmoon/spark_core/animation/IAnimatable;", "currentModel", "Lcn/solarmoon/spark_core/animation/model/ModelInstance;", "originModel", "Lcn/solarmoon/spark_core/animation/model/origin/OModel;", "getOriginModel", "()Lcn/solarmoon/spark_core/animation/model/origin/OModel;", "model", "getModel", "()Lcn/solarmoon/spark_core/animation/model/ModelInstance;", "textureLocation", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "getTextureLocation", "()Lnet/minecraft/resources/ResourceLocation;", "setModel", "", "index", "Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "setTextureLocation", "location", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelController.kt\ncn/solarmoon/spark_core/animation/model/ModelController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class ModelController {
    @NotNull
    private final IAnimatable<?> animatable;
    @Nullable
    private ModelInstance currentModel;

    public ModelController(@NotNull IAnimatable<?> animatable) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        this.animatable = animatable;
        this.currentModel = new ModelInstance(this.animatable, this.animatable.getDefaultModelIndex());
    }

    @NotNull
    public final IAnimatable<?> getAnimatable() {
        return this.animatable;
    }

    @NotNull
    public final OModel getOriginModel() {
        ModelInstance modelInstance = this.getModel();
        return OModel.Companion.getOrEmpty(modelInstance != null ? modelInstance.getIndex() : null);
    }

    @Nullable
    public final ModelInstance getModel() {
        return this.currentModel;
    }

    public final ResourceLocation getTextureLocation() {
        ModelInstance modelInstance = this.getModel();
        if (modelInstance == null || (modelInstance = modelInstance.getTextureLocation()) == null) {
            modelInstance = ResourceLocation.withDefaultNamespace((String)"missingno");
        }
        return modelInstance;
    }

    public final void setModel(@Nullable ModelIndex index) {
        ModelInstance modelInstance;
        ModelIndex modelIndex = index;
        if (modelIndex != null) {
            ModelIndex it = modelIndex;
            boolean bl = false;
            modelInstance = new ModelInstance(this.animatable, it);
        } else {
            modelInstance = null;
        }
        ModelInstance m = modelInstance;
        this.setModel(m);
    }

    public final void setModel(@Nullable ModelInstance model) {
        ModelChangeEvent event = (ModelChangeEvent)NeoForge.EVENT_BUS.post((Event)new ModelChangeEvent(this.animatable, this.currentModel, model));
        this.currentModel = event.getNewModel();
    }

    public final void setTextureLocation(@Nullable ResourceLocation location) {
        block1: {
            ModelInstance modelInstance = this.getModel();
            if (modelInstance == null) break block1;
            ResourceLocation resourceLocation = location;
            if (resourceLocation == null) {
                ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"missingno");
                resourceLocation = resourceLocation2;
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"withDefaultNamespace(...)");
            }
            modelInstance.setTextureLocation(resourceLocation);
        }
    }
}

