/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.model;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.model.ModelIndex;
import cn.solarmoon.spark_core.animation.model.ModelPose;
import cn.solarmoon.spark_core.animation.model.origin.OModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcn/solarmoon/spark_core/animation/model/ModelInstance;", "", "animatable", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "index", "Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "<init>", "(Lcn/solarmoon/spark_core/animation/IAnimatable;Lcn/solarmoon/spark_core/animation/model/ModelIndex;)V", "getAnimatable", "()Lcn/solarmoon/spark_core/animation/IAnimatable;", "getIndex", "()Lcn/solarmoon/spark_core/animation/model/ModelIndex;", "origin", "Lcn/solarmoon/spark_core/animation/model/origin/OModel;", "getOrigin", "()Lcn/solarmoon/spark_core/animation/model/origin/OModel;", "pose", "Lcn/solarmoon/spark_core/animation/model/ModelPose;", "getPose", "()Lcn/solarmoon/spark_core/animation/model/ModelPose;", "textureLocation", "Lnet/minecraft/resources/ResourceLocation;", "getTextureLocation", "()Lnet/minecraft/resources/ResourceLocation;", "setTextureLocation", "(Lnet/minecraft/resources/ResourceLocation;)V", "SparkCore-1.21.1-neoforge"})
public final class ModelInstance {
    @NotNull
    private final IAnimatable<?> animatable;
    @NotNull
    private final ModelIndex index;
    @NotNull
    private final ModelPose pose;
    @NotNull
    private ResourceLocation textureLocation;

    public ModelInstance(@NotNull IAnimatable<?> animatable, @NotNull ModelIndex index) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.animatable = animatable;
        this.index = index;
        this.pose = new ModelPose(this);
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)this.index.getLocation().getNamespace(), (String)("textures/" + this.index.getType() + "/" + this.index.getLocation().getPath() + ".png"));
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        this.textureLocation = resourceLocation;
    }

    @NotNull
    public final IAnimatable<?> getAnimatable() {
        return this.animatable;
    }

    @NotNull
    public final ModelIndex getIndex() {
        return this.index;
    }

    @NotNull
    public final OModel getOrigin() {
        return OModel.Companion.getOrEmpty(this.index);
    }

    @NotNull
    public final ModelPose getPose() {
        return this.pose;
    }

    @NotNull
    public final ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public final void setTextureLocation(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.textureLocation = resourceLocation;
    }
}

