/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.model;

import cn.solarmoon.spark_core.animation.model.BonePose;
import cn.solarmoon.spark_core.animation.model.ModelInstance;
import cn.solarmoon.spark_core.animation.model.origin.OBone;
import cn.solarmoon.spark_core.animation.model.origin.OLocator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\nJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\"\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcn/solarmoon/spark_core/animation/model/ModelPose;", "", "model", "Lcn/solarmoon/spark_core/animation/model/ModelInstance;", "<init>", "(Lcn/solarmoon/spark_core/animation/model/ModelInstance;)V", "getModel", "()Lcn/solarmoon/spark_core/animation/model/ModelInstance;", "bonePoses", "Ljava/util/HashMap;", "", "Lcn/solarmoon/spark_core/animation/model/BonePose;", "Lkotlin/collections/HashMap;", "getBonePoses", "()Ljava/util/HashMap;", "getBonePose", "name", "getBonePoseOrCreateEmpty", "getSpaceBoneLocatorMatrix", "Lorg/joml/Matrix4f;", "partialTicks", "", "getSpaceLocator", "Lorg/joml/Vector3f;", "offset", "Lnet/minecraft/world/phys/Vec3;", "getWorldBoneLocatorMatrix", "getWorldLocator", "copy", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nModelPose.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelPose.kt\ncn/solarmoon/spark_core/animation/model/ModelPose\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,55:1\n384#2,7:56\n*S KotlinDebug\n*F\n+ 1 ModelPose.kt\ncn/solarmoon/spark_core/animation/model/ModelPose\n*L\n24#1:56,7\n*E\n"})
public final class ModelPose {
    @NotNull
    private final ModelInstance model;
    @NotNull
    private final HashMap<String, BonePose> bonePoses;

    public ModelPose(@NotNull ModelInstance model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        this.bonePoses = new HashMap();
        Iterator<OBone> iterator = this.model.getOrigin().getBones().values().iterator();
        while (iterator.hasNext()) {
            OBone bone;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            BonePose pose = new BonePose(this.model, bone.getName());
            ((Map)this.bonePoses).put(bone.getName(), pose);
        }
    }

    @NotNull
    public final ModelInstance getModel() {
        return this.model;
    }

    @NotNull
    public final HashMap<String, BonePose> getBonePoses() {
        return this.bonePoses;
    }

    @NotNull
    public final BonePose getBonePose(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BonePose bonePose = this.bonePoses.get(name);
        Intrinsics.checkNotNull((Object)bonePose);
        return bonePose;
    }

    @NotNull
    public final BonePose getBonePoseOrCreateEmpty(@NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map $this$getOrPut$iv = this.bonePoses;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            BonePose answer$iv = new BonePose(this.model, name);
            $this$getOrPut$iv.put(name, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (BonePose)object;
    }

    @NotNull
    public final Matrix4f getSpaceBoneLocatorMatrix(@NotNull String name, @NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        OLocator oLocator = this.model.getOrigin().getLocators().get(name);
        if (oLocator == null) {
            return new Matrix4f();
        }
        OLocator locator = oLocator;
        Matrix4f spaceMatrix = this.getBonePose(locator.getBone().getName()).getSpaceBoneMatrix(partialTicks);
        Matrix4f matrix4f = spaceMatrix.translate((Vector3fc)locator.getOffset().toVector3f()).rotateZYX(locator.getRotation().toVector3f());
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"rotateZYX(...)");
        return matrix4f;
    }

    public static /* synthetic */ Matrix4f getSpaceBoneLocatorMatrix$default(ModelPose modelPose, String string, Number number, int n, Object object) {
        if ((n & 2) != 0) {
            number = 1.0;
        }
        return modelPose.getSpaceBoneLocatorMatrix(string, number);
    }

    @NotNull
    public final Vector3f getSpaceLocator(@NotNull String name, @NotNull Vec3 offset, @NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Matrix4f locatorMatrix = this.getSpaceBoneLocatorMatrix(name, partialTicks);
        Vector3f vector3f = locatorMatrix.transformPosition(offset.toVector3f());
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"transformPosition(...)");
        return vector3f;
    }

    public static /* synthetic */ Vector3f getSpaceLocator$default(ModelPose modelPose, String string, Vec3 vec3, Number number, int n, Object object) {
        if ((n & 2) != 0) {
            vec3 = Vec3.ZERO;
        }
        if ((n & 4) != 0) {
            number = 1.0;
        }
        return modelPose.getSpaceLocator(string, vec3, number);
    }

    @NotNull
    public final Matrix4f getWorldBoneLocatorMatrix(@NotNull String name, @NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Matrix4f matrix4f = this.model.getAnimatable().getWorldPositionMatrix(Float.valueOf(partialTicks.floatValue())).mul((Matrix4fc)this.getSpaceBoneLocatorMatrix(name, partialTicks));
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"mul(...)");
        return matrix4f;
    }

    public static /* synthetic */ Matrix4f getWorldBoneLocatorMatrix$default(ModelPose modelPose, String string, Number number, int n, Object object) {
        if ((n & 2) != 0) {
            number = 1.0;
        }
        return modelPose.getWorldBoneLocatorMatrix(string, number);
    }

    @NotNull
    public final Vector3f getWorldLocator(@NotNull String name, @NotNull Vec3 offset, @NotNull Number partialTicks) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)partialTicks, (String)"partialTicks");
        Vector3f vector3f = this.model.getAnimatable().getWorldPositionMatrix(Float.valueOf(partialTicks.floatValue())).transformPosition(this.getSpaceLocator(name, offset, partialTicks));
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"transformPosition(...)");
        return vector3f;
    }

    public static /* synthetic */ Vector3f getWorldLocator$default(ModelPose modelPose, String string, Vec3 vec3, Number number, int n, Object object) {
        if ((n & 2) != 0) {
            vec3 = Vec3.ZERO;
        }
        if ((n & 4) != 0) {
            number = 1.0;
        }
        return modelPose.getWorldLocator(string, vec3, number);
    }

    @NotNull
    public final ModelPose copy() {
        ModelPose copy = new ModelPose(this.model);
        for (Map.Entry entry : ((Map)this.bonePoses).entrySet()) {
            String key = (String)entry.getKey();
            BonePose value = (BonePose)entry.getValue();
            ((Map)copy.bonePoses).put(key, value.copy());
        }
        return copy;
    }
}

