/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.model.origin;

import cn.solarmoon.spark_core.animation.model.origin.OBone;
import cn.solarmoon.spark_core.animation.model.origin.OPolygon;
import cn.solarmoon.spark_core.animation.model.origin.OUVUnion;
import cn.solarmoon.spark_core.animation.model.origin.OVertex;
import cn.solarmoon.spark_core.animation.model.origin.OVertexSet;
import cn.solarmoon.spark_core.util.SerializeHelper;
import cn.solarmoon.spark_core.util.SparkMathKt;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 U2\u00020\u0001:\u0001UBO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0014\u00103\u001a\b\u0012\u0004\u0012\u0002040/2\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u0002082\u0006\u00105\u001a\u000206J\u000e\u00109\u001a\u0002042\u0006\u00105\u001a\u000206JB\u0010:\u001a\u00020;2\u0006\u00105\u001a\u0002062\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u000e2\b\b\u0002\u0010C\u001a\u00020\fH\u0007J\u0010\u0010D\u001a\u00020;2\u0006\u0010E\u001a\u000204H\u0002J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J\t\u0010G\u001a\u00020\u0003H\u00c6\u0003J\t\u0010H\u001a\u00020\u0003H\u00c6\u0003J\t\u0010I\u001a\u00020\u0003H\u00c6\u0003J\t\u0010J\u001a\u00020\bH\u00c6\u0003J\t\u0010K\u001a\u00020\nH\u00c6\u0003J\t\u0010L\u001a\u00020\fH\u00c6\u0003J\t\u0010M\u001a\u00020\u000eH\u00c6\u0003J\t\u0010N\u001a\u00020\u000eH\u00c6\u0003Jc\u0010O\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010P\u001a\u00020\f2\b\u0010Q\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010R\u001a\u00020\u000eH\u00d6\u0001J\t\u0010S\u001a\u00020TH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u0002000/\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006V"}, d2={"Lcn/solarmoon/spark_core/animation/model/origin/OCube;", "", "originPos", "Lnet/minecraft/world/phys/Vec3;", "size", "pivot", "rotation", "inflate", "", "uvUnion", "Lcn/solarmoon/spark_core/animation/model/origin/OUVUnion;", "mirror", "", "textureWidth", "", "textureHeight", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;DLcn/solarmoon/spark_core/animation/model/origin/OUVUnion;ZII)V", "getOriginPos", "()Lnet/minecraft/world/phys/Vec3;", "setOriginPos", "(Lnet/minecraft/world/phys/Vec3;)V", "getSize", "getPivot", "getRotation", "getInflate", "()D", "setInflate", "(D)V", "getUvUnion", "()Lcn/solarmoon/spark_core/animation/model/origin/OUVUnion;", "getMirror", "()Z", "getTextureWidth", "()I", "getTextureHeight", "rootBone", "Lcn/solarmoon/spark_core/animation/model/origin/OBone;", "getRootBone", "()Lcn/solarmoon/spark_core/animation/model/origin/OBone;", "setRootBone", "(Lcn/solarmoon/spark_core/animation/model/origin/OBone;)V", "vertices", "Lcn/solarmoon/spark_core/animation/model/origin/OVertexSet;", "getVertices", "()Lcn/solarmoon/spark_core/animation/model/origin/OVertexSet;", "polygonSet", "", "Lcn/solarmoon/spark_core/animation/model/origin/OPolygon;", "getPolygonSet", "()Ljava/util/List;", "getTransformedVertices", "Lorg/joml/Vector3f;", "matrix4f", "Lorg/joml/Matrix4f;", "getTransformedRotation", "Lorg/joml/Quaternionf;", "getTransformedCenter", "renderVertexes", "", "normal3f", "Lorg/joml/Matrix3f;", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "packedOverlay", "color", "gui", "fixInvertedFlatCube", "normal", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nOCube.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCube.kt\ncn/solarmoon/spark_core/animation/model/origin/OCube\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1761#2,3:186\n1740#2,3:189\n*S KotlinDebug\n*F\n+ 1 OCube.kt\ncn/solarmoon/spark_core/animation/model/origin/OCube\n*L\n61#1:186,3\n105#1:189,3\n*E\n"})
public final class OCube {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vec3 originPos;
    @NotNull
    private final Vec3 size;
    @NotNull
    private final Vec3 pivot;
    @NotNull
    private final Vec3 rotation;
    private double inflate;
    @NotNull
    private final OUVUnion uvUnion;
    private final boolean mirror;
    private final int textureWidth;
    private final int textureHeight;
    @Nullable
    private OBone rootBone;
    @NotNull
    private final OVertexSet vertices;
    @NotNull
    private final List<OPolygon> polygonSet;
    @NotNull
    private static final Codec<OCube> CODEC;
    private static final Codec<List<OCube>> LIST_CODEC;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, OCube> STREAM_CODEC;
    private static final StreamCodec<FriendlyByteBuf, List<OCube>> LIST_STREAM_CODEC;

    public OCube(@NotNull Vec3 originPos, @NotNull Vec3 size, @NotNull Vec3 pivot, @NotNull Vec3 rotation, double inflate, @NotNull OUVUnion uvUnion, boolean mirror, int textureWidth, int textureHeight) {
        Intrinsics.checkNotNullParameter((Object)originPos, (String)"originPos");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Intrinsics.checkNotNullParameter((Object)uvUnion, (String)"uvUnion");
        this.originPos = originPos;
        this.size = size;
        this.pivot = pivot;
        this.rotation = rotation;
        this.inflate = inflate;
        this.uvUnion = uvUnion;
        this.mirror = mirror;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.vertices = new OVertexSet(this.originPos, this.size, this.inflate);
        Object[] objectArray = new OPolygon[]{OPolygon.Companion.of(this.vertices, this, Direction.WEST), OPolygon.Companion.of(this.vertices, this, Direction.EAST), OPolygon.Companion.of(this.vertices, this, Direction.NORTH), OPolygon.Companion.of(this.vertices, this, Direction.SOUTH), OPolygon.Companion.of(this.vertices, this, Direction.UP), OPolygon.Companion.of(this.vertices, this, Direction.DOWN)};
        this.polygonSet = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Vec3 getOriginPos() {
        return this.originPos;
    }

    public final void setOriginPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.originPos = vec3;
    }

    @NotNull
    public final Vec3 getSize() {
        return this.size;
    }

    @NotNull
    public final Vec3 getPivot() {
        return this.pivot;
    }

    @NotNull
    public final Vec3 getRotation() {
        return this.rotation;
    }

    public final double getInflate() {
        return this.inflate;
    }

    public final void setInflate(double d) {
        this.inflate = d;
    }

    @NotNull
    public final OUVUnion getUvUnion() {
        return this.uvUnion;
    }

    public final boolean getMirror() {
        return this.mirror;
    }

    public final int getTextureWidth() {
        return this.textureWidth;
    }

    public final int getTextureHeight() {
        return this.textureHeight;
    }

    @Nullable
    public final OBone getRootBone() {
        return this.rootBone;
    }

    public final void setRootBone(@Nullable OBone oBone) {
        this.rootBone = oBone;
    }

    @NotNull
    public final OVertexSet getVertices() {
        return this.vertices;
    }

    @NotNull
    public final List<OPolygon> getPolygonSet() {
        return this.polygonSet;
    }

    @NotNull
    public final List<Vector3f> getTransformedVertices(@NotNull Matrix4f matrix4f) {
        Intrinsics.checkNotNullParameter((Object)matrix4f, (String)"matrix4f");
        matrix4f.translate((Vector3fc)this.pivot.toVector3f());
        matrix4f.rotateZYX(this.rotation.toVector3f());
        matrix4f.translate((Vector3fc)SparkMathKt.div(this.pivot, -1.0).toVector3f());
        ArrayList<Vector3f> list = new ArrayList<Vector3f>();
        for (OPolygon polygon : this.polygonSet) {
            for (OVertex vertex : polygon.getVertexes()) {
                boolean bl;
                Vector3f vector3f2;
                block5: {
                    vector3f2 = matrix4f.transformPosition(vertex.getX(), vertex.getY(), vertex.getZ(), new Vector3f());
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Vector3f it = (Vector3f)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)vector3f2)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                list.add(vector3f2);
            }
        }
        return CollectionsKt.toList((Iterable)list);
    }

    @NotNull
    public final Quaternionf getTransformedRotation(@NotNull Matrix4f matrix4f) {
        Intrinsics.checkNotNullParameter((Object)matrix4f, (String)"matrix4f");
        Matrix4f correctedMatrix = new Matrix4f((Matrix4fc)matrix4f);
        correctedMatrix.translate((Vector3fc)this.pivot.toVector3f());
        correctedMatrix.rotateZYX(this.rotation.toVector3f());
        correctedMatrix.translate((Vector3fc)this.pivot.toVector3f().negate());
        Quaternionf quaternionf = correctedMatrix.getUnnormalizedRotation(new Quaternionf());
        Intrinsics.checkNotNullExpressionValue((Object)quaternionf, (String)"getUnnormalizedRotation(...)");
        return quaternionf;
    }

    @NotNull
    public final Vector3f getTransformedCenter(@NotNull Matrix4f matrix4f) {
        Intrinsics.checkNotNullParameter((Object)matrix4f, (String)"matrix4f");
        Matrix4f matrix4f2 = new Matrix4f((Matrix4fc)matrix4f);
        matrix4f2.translate((Vector3fc)this.pivot.toVector3f());
        matrix4f2.rotateZYX(this.rotation.toVector3f());
        matrix4f2.translate((Vector3fc)SparkMathKt.div(this.pivot, -1.0).toVector3f());
        Vector3f oCenter = this.originPos.toVector3f().add((Vector3fc)this.size.toVector3f().mul(0.5f));
        Vector3f center = matrix4f2.transformPosition((Vector3fc)oCenter, new Vector3f());
        Intrinsics.checkNotNull((Object)center);
        return center;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void renderVertexes(@NotNull Matrix4f matrix4f, @NotNull Matrix3f normal3f, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color, boolean gui) {
        Intrinsics.checkNotNullParameter((Object)matrix4f, (String)"matrix4f");
        Intrinsics.checkNotNullParameter((Object)normal3f, (String)"normal3f");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        matrix4f.translate((Vector3fc)this.pivot.toVector3f());
        matrix4f.rotateZYX(this.rotation.toVector3f());
        matrix4f.translate((Vector3fc)SparkMathKt.div(this.pivot, -1.0).toVector3f());
        for (OPolygon polygon : this.polygonSet) {
            boolean bl;
            Vector3f normal;
            block6: {
                normal = normal3f.transform((Vector3fc)polygon.getNormal(), new Vector3f());
                Object[] objectArray = new Float[]{Float.valueOf(polygon.getU1()), Float.valueOf(polygon.getU2()), Float.valueOf(polygon.getV1()), Float.valueOf(polygon.getV2())};
                Iterable $this$all$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        float it = ((Number)element$iv).floatValue();
                        boolean bl2 = false;
                        if (it == 0.0f) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) continue;
            Intrinsics.checkNotNull((Object)normal);
            this.fixInvertedFlatCube(normal);
            for (OVertex vertex : polygon.getVertexes()) {
                Vector3f cam = new Vector3f();
                if (!gui) {
                    cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
                }
                Vector3f vector3f2 = matrix4f.transformPosition(vertex.getX(), vertex.getY(), vertex.getZ(), new Vector3f()).sub((Vector3fc)cam);
                buffer.addVertex(vector3f2.x(), vector3f2.y(), vector3f2.z(), color, vertex.getU(), vertex.getV(), packedOverlay, packedLight, normal.x, normal.y, normal.z);
            }
        }
    }

    public static /* synthetic */ void renderVertexes$default(OCube oCube, Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            bl = false;
        }
        oCube.renderVertexes(matrix4f, matrix3f, vertexConsumer, n, n2, n3, bl);
    }

    private final void fixInvertedFlatCube(Vector3f normal) {
        if (normal.x < 0.0f && (this.size.y == 0.0 || this.size.z == 0.0)) {
            normal.set(0.0f, 1.0f, 0.0f);
        }
        if (normal.y < 0.0f && (this.size.x == 0.0 || this.size.z == 0.0)) {
            normal.set(0.0f, 1.0f, 0.0f);
        }
        if (normal.z < 0.0f && (this.size.x == 0.0 || this.size.y == 0.0)) {
            normal.set(0.0f, 1.0f, 0.0f);
        }
    }

    @NotNull
    public final Vec3 component1() {
        return this.originPos;
    }

    @NotNull
    public final Vec3 component2() {
        return this.size;
    }

    @NotNull
    public final Vec3 component3() {
        return this.pivot;
    }

    @NotNull
    public final Vec3 component4() {
        return this.rotation;
    }

    public final double component5() {
        return this.inflate;
    }

    @NotNull
    public final OUVUnion component6() {
        return this.uvUnion;
    }

    public final boolean component7() {
        return this.mirror;
    }

    public final int component8() {
        return this.textureWidth;
    }

    public final int component9() {
        return this.textureHeight;
    }

    @NotNull
    public final OCube copy(@NotNull Vec3 originPos, @NotNull Vec3 size, @NotNull Vec3 pivot, @NotNull Vec3 rotation, double inflate, @NotNull OUVUnion uvUnion, boolean mirror, int textureWidth, int textureHeight) {
        Intrinsics.checkNotNullParameter((Object)originPos, (String)"originPos");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Intrinsics.checkNotNullParameter((Object)uvUnion, (String)"uvUnion");
        return new OCube(originPos, size, pivot, rotation, inflate, uvUnion, mirror, textureWidth, textureHeight);
    }

    public static /* synthetic */ OCube copy$default(OCube oCube, Vec3 vec3, Vec3 vec32, Vec3 vec33, Vec3 vec34, double d, OUVUnion oUVUnion, boolean bl, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            vec3 = oCube.originPos;
        }
        if ((n3 & 2) != 0) {
            vec32 = oCube.size;
        }
        if ((n3 & 4) != 0) {
            vec33 = oCube.pivot;
        }
        if ((n3 & 8) != 0) {
            vec34 = oCube.rotation;
        }
        if ((n3 & 0x10) != 0) {
            d = oCube.inflate;
        }
        if ((n3 & 0x20) != 0) {
            oUVUnion = oCube.uvUnion;
        }
        if ((n3 & 0x40) != 0) {
            bl = oCube.mirror;
        }
        if ((n3 & 0x80) != 0) {
            n = oCube.textureWidth;
        }
        if ((n3 & 0x100) != 0) {
            n2 = oCube.textureHeight;
        }
        return oCube.copy(vec3, vec32, vec33, vec34, d, oUVUnion, bl, n, n2);
    }

    @NotNull
    public String toString() {
        return "OCube(originPos=" + this.originPos + ", size=" + this.size + ", pivot=" + this.pivot + ", rotation=" + this.rotation + ", inflate=" + this.inflate + ", uvUnion=" + this.uvUnion + ", mirror=" + this.mirror + ", textureWidth=" + this.textureWidth + ", textureHeight=" + this.textureHeight + ")";
    }

    public int hashCode() {
        int result = this.originPos.hashCode();
        result = result * 31 + this.size.hashCode();
        result = result * 31 + this.pivot.hashCode();
        result = result * 31 + this.rotation.hashCode();
        result = result * 31 + Double.hashCode(this.inflate);
        result = result * 31 + this.uvUnion.hashCode();
        result = result * 31 + Boolean.hashCode(this.mirror);
        result = result * 31 + Integer.hashCode(this.textureWidth);
        result = result * 31 + Integer.hashCode(this.textureHeight);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OCube)) {
            return false;
        }
        OCube oCube = (OCube)other;
        if (!Intrinsics.areEqual((Object)this.originPos, (Object)oCube.originPos)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)oCube.size)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pivot, (Object)oCube.pivot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rotation, (Object)oCube.rotation)) {
            return false;
        }
        if (Double.compare(this.inflate, oCube.inflate) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.uvUnion, (Object)oCube.uvUnion)) {
            return false;
        }
        if (this.mirror != oCube.mirror) {
            return false;
        }
        if (this.textureWidth != oCube.textureWidth) {
            return false;
        }
        return this.textureHeight == oCube.textureHeight;
    }

    private static final Vec3 CODEC$lambda$11$lambda$2(OCube it) {
        return it.originPos;
    }

    private static final Vec3 CODEC$lambda$11$lambda$3(OCube it) {
        return it.size;
    }

    private static final Vec3 CODEC$lambda$11$lambda$4(OCube it) {
        return it.pivot;
    }

    private static final Vec3 CODEC$lambda$11$lambda$5(OCube it) {
        return it.rotation;
    }

    private static final Double CODEC$lambda$11$lambda$6(OCube it) {
        return it.inflate;
    }

    private static final OUVUnion CODEC$lambda$11$lambda$7(OCube it) {
        return it.uvUnion;
    }

    private static final Boolean CODEC$lambda$11$lambda$8(OCube it) {
        return it.mirror;
    }

    private static final Integer CODEC$lambda$11$lambda$9(OCube it) {
        return it.textureWidth;
    }

    private static final Integer CODEC$lambda$11$lambda$10(OCube it) {
        return it.textureHeight;
    }

    private static final App CODEC$lambda$11(RecordCodecBuilder.Instance it) {
        return it.group((App)Vec3.CODEC.optionalFieldOf("origin", (Object)Vec3.ZERO).forGetter(OCube::CODEC$lambda$11$lambda$2), (App)Vec3.CODEC.optionalFieldOf("size", (Object)Vec3.ZERO).forGetter(OCube::CODEC$lambda$11$lambda$3), (App)Vec3.CODEC.optionalFieldOf("pivot", (Object)Vec3.ZERO).forGetter(OCube::CODEC$lambda$11$lambda$4), (App)Vec3.CODEC.optionalFieldOf("rotation", (Object)Vec3.ZERO).forGetter(OCube::CODEC$lambda$11$lambda$5), (App)Codec.DOUBLE.optionalFieldOf("inflate", (Object)0.0).forGetter(OCube::CODEC$lambda$11$lambda$6), (App)OUVUnion.Companion.getCODEC().optionalFieldOf("uv", (Object)new OUVUnion(Vec2.ZERO, null)).forGetter(OCube::CODEC$lambda$11$lambda$7), (App)Codec.BOOL.optionalFieldOf("mirror", (Object)false).forGetter(OCube::CODEC$lambda$11$lambda$8), (App)Codec.INT.optionalFieldOf("textureWidth", (Object)16).forGetter(OCube::CODEC$lambda$11$lambda$9), (App)Codec.INT.optionalFieldOf("textureHeight", (Object)16).forGetter(OCube::CODEC$lambda$11$lambda$10)).apply((Applicative)it, OCube::new);
    }

    private static final List LIST_STREAM_CODEC$lambda$12(int it) {
        return new ArrayList();
    }

    private static final List LIST_STREAM_CODEC$lambda$13(List it) {
        Intrinsics.checkNotNull((Object)it);
        return CollectionsKt.toList((Iterable)it);
    }

    private static final List LIST_STREAM_CODEC$lambda$14(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List LIST_STREAM_CODEC$lambda$15(List it) {
        Intrinsics.checkNotNull((Object)it);
        return CollectionsKt.toMutableList((Collection)it);
    }

    private static final List LIST_STREAM_CODEC$lambda$16(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @NotNull
    public static final Codec<OCube> getCODEC() {
        return Companion.getCODEC();
    }

    public static final Codec<List<OCube>> getLIST_CODEC() {
        return Companion.getLIST_CODEC();
    }

    @NotNull
    public static final StreamCodec<FriendlyByteBuf, OCube> getSTREAM_CODEC() {
        return Companion.getSTREAM_CODEC();
    }

    public static final StreamCodec<FriendlyByteBuf, List<OCube>> getLIST_STREAM_CODEC() {
        return Companion.getLIST_STREAM_CODEC();
    }

    static {
        Codec codec2 = RecordCodecBuilder.create(OCube::CODEC$lambda$11);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
        CODEC = codec2;
        LIST_CODEC = CODEC.listOf();
        STREAM_CODEC = (StreamCodec)new StreamCodec<FriendlyByteBuf, OCube>(){

            public OCube decode(FriendlyByteBuf buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                Vec3 origin = (Vec3)SerializeHelper.getVEC3_STREAM_CODEC().decode((Object)buffer);
                Vec3 size = (Vec3)SerializeHelper.getVEC3_STREAM_CODEC().decode((Object)buffer);
                Vec3 pivot = (Vec3)SerializeHelper.getVEC3_STREAM_CODEC().decode((Object)buffer);
                Vec3 rotation = (Vec3)SerializeHelper.getVEC3_STREAM_CODEC().decode((Object)buffer);
                double inflate = buffer.readDouble();
                OUVUnion uv = (OUVUnion)OUVUnion.Companion.getSTREAM_CODEC().decode((Object)buffer);
                boolean mirror = buffer.readBoolean();
                int tw = buffer.readInt();
                int th = buffer.readInt();
                Intrinsics.checkNotNull((Object)origin);
                Intrinsics.checkNotNull((Object)size);
                Intrinsics.checkNotNull((Object)pivot);
                Intrinsics.checkNotNull((Object)rotation);
                Intrinsics.checkNotNull((Object)uv);
                return new OCube(origin, size, pivot, rotation, inflate, uv, mirror, tw, th);
            }

            public void encode(FriendlyByteBuf buffer, OCube value) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                SerializeHelper.getVEC3_STREAM_CODEC().encode((Object)buffer, (Object)value.getOriginPos());
                SerializeHelper.getVEC3_STREAM_CODEC().encode((Object)buffer, (Object)value.getSize());
                SerializeHelper.getVEC3_STREAM_CODEC().encode((Object)buffer, (Object)value.getPivot());
                SerializeHelper.getVEC3_STREAM_CODEC().encode((Object)buffer, (Object)value.getRotation());
                buffer.writeDouble(value.getInflate());
                OUVUnion.Companion.getSTREAM_CODEC().encode((Object)buffer, (Object)value.getUvUnion());
                buffer.writeBoolean(value.getMirror());
                buffer.writeInt(value.getTextureWidth());
                buffer.writeInt(value.getTextureHeight());
            }
        };
        LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(OCube::LIST_STREAM_CODEC$lambda$12)).map(arg_0 -> OCube.LIST_STREAM_CODEC$lambda$14(OCube::LIST_STREAM_CODEC$lambda$13, arg_0), arg_0 -> OCube.LIST_STREAM_CODEC$lambda$16(OCube::LIST_STREAM_CODEC$lambda$15, arg_0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tRz\u0010\n\u001a^\u0012(\u0012&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\r0\u000b \f*.\u0012(\u0012&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\r0\u000b\u0018\u00010\u00050\u00058\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0010\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\tR(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\u0016R\u0096\u0001\u0010\u0017\u001az\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u0013\u0012(\u0012&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\r0\r \f*<\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u0013\u0012(\u0012&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\r0\r\u0018\u00010\u00120\u00128\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u001a\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcn/solarmoon/spark_core/animation/model/origin/OCube$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lcn/solarmoon/spark_core/animation/model/origin/OCube;", "getCODEC$annotations", "getCODEC", "()Lcom/mojang/serialization/Codec;", "LIST_CODEC", "", "kotlin.jvm.PlatformType", "", "getLIST_CODEC$annotations", "getLIST_CODEC", "Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "getSTREAM_CODEC$annotations", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "LIST_STREAM_CODEC", "getLIST_STREAM_CODEC$annotations", "getLIST_STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<OCube> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCODEC$annotations() {
        }

        public final Codec<List<OCube>> getLIST_CODEC() {
            return LIST_CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getLIST_CODEC$annotations() {
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, OCube> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getSTREAM_CODEC$annotations() {
        }

        public final StreamCodec<FriendlyByteBuf, List<OCube>> getLIST_STREAM_CODEC() {
            return LIST_STREAM_CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getLIST_STREAM_CODEC$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

