/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.model.origin;

import cn.solarmoon.spark_core.animation.model.origin.OCube;
import cn.solarmoon.spark_core.animation.model.origin.OUVUnion;
import cn.solarmoon.spark_core.animation.model.origin.OVertex;
import cn.solarmoon.spark_core.animation.model.origin.OVertexSet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 =2\u00020\u0001:\u0001=B]\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\t\u0010-\u001a\u00020\u0006H\u00c6\u0003J\t\u0010.\u001a\u00020\u0006H\u00c6\u0003J\t\u0010/\u001a\u00020\u0006H\u00c6\u0003J\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\t\u00101\u001a\u00020\u0006H\u00c6\u0003J\t\u00102\u001a\u00020\rH\u00c6\u0003J\t\u00103\u001a\u00020\u000fH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003Jx\u00105\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\rH\u00c6\u0001\u00a2\u0006\u0002\u00106J\u0013\u00107\u001a\u00020\r2\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001J\t\u0010;\u001a\u00020<H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010#R\u0019\u0010&\u001a\n (*\u0004\u0018\u00010'0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006>"}, d2={"Lcn/solarmoon/spark_core/animation/model/origin/OPolygon;", "", "vertexes", "", "Lcn/solarmoon/spark_core/animation/model/origin/OVertex;", "u1", "", "v1", "u2", "v2", "textureWidth", "textureHeight", "mirror", "", "direction", "Lnet/minecraft/core/Direction;", "isBoxUv", "<init>", "([Lcn/solarmoon/spark_core/animation/model/origin/OVertex;FFFFFFZLnet/minecraft/core/Direction;Z)V", "getVertexes", "()[Lcn/solarmoon/spark_core/animation/model/origin/OVertex;", "[Lcn/solarmoon/spark_core/animation/model/origin/OVertex;", "getU1", "()F", "setU1", "(F)V", "getV1", "setV1", "getU2", "setU2", "getV2", "setV2", "getTextureWidth", "getTextureHeight", "getMirror", "()Z", "getDirection", "()Lnet/minecraft/core/Direction;", "normal", "Lorg/joml/Vector3f;", "kotlin.jvm.PlatformType", "getNormal", "()Lorg/joml/Vector3f;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "([Lcn/solarmoon/spark_core/animation/model/origin/OVertex;FFFFFFZLnet/minecraft/core/Direction;Z)Lcn/solarmoon/spark_core/animation/model/origin/OPolygon;", "equals", "other", "hashCode", "", "toString", "", "Companion", "SparkCore-1.21.1-neoforge"})
public final class OPolygon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OVertex[] vertexes;
    private float u1;
    private float v1;
    private float u2;
    private float v2;
    private final float textureWidth;
    private final float textureHeight;
    private final boolean mirror;
    @NotNull
    private final Direction direction;
    private final boolean isBoxUv;

    public OPolygon(@NotNull OVertex[] vertexes, float u1, float v1, float u2, float v2, float textureWidth, float textureHeight, boolean mirror, @NotNull Direction direction2, boolean isBoxUv) {
        Intrinsics.checkNotNullParameter((Object)vertexes, (String)"vertexes");
        Intrinsics.checkNotNullParameter((Object)direction2, (String)"direction");
        this.vertexes = vertexes;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.mirror = mirror;
        this.direction = direction2;
        this.isBoxUv = isBoxUv;
        if (!this.isBoxUv) {
            if (this.mirror) {
                float tempWidth = this.u2;
                this.u2 = this.u1;
                this.u1 = tempWidth;
            } else {
                this.getNormal().mul(-1.0f, 1.0f, 1.0f);
            }
            this.vertexes[1] = this.vertexes[1].remap(this.u1 / this.textureWidth, this.v1 / this.textureHeight);
            this.vertexes[0] = this.vertexes[0].remap((this.u1 + this.u2) / this.textureWidth, this.v1 / this.textureHeight);
            this.vertexes[3] = this.vertexes[3].remap((this.u1 + this.u2) / this.textureWidth, (this.v1 + this.v2) / this.textureHeight);
            this.vertexes[2] = this.vertexes[2].remap(this.u1 / this.textureWidth, (this.v1 + this.v2) / this.textureHeight);
        } else {
            if (!this.mirror) {
                float tempWidth = this.u2;
                this.u2 = this.u1;
                this.u1 = tempWidth;
            } else {
                this.getNormal().mul(-1.0f, 1.0f, 1.0f);
            }
            this.vertexes[0] = this.vertexes[0].remap(this.u1 / this.textureWidth, this.v1 / this.textureHeight);
            this.vertexes[1] = this.vertexes[1].remap(this.u2 / this.textureWidth, this.v1 / this.textureHeight);
            this.vertexes[2] = this.vertexes[2].remap(this.u2 / this.textureWidth, this.v2 / this.textureHeight);
            this.vertexes[3] = this.vertexes[3].remap(this.u1 / this.textureWidth, this.v2 / this.textureHeight);
        }
    }

    @NotNull
    public final OVertex[] getVertexes() {
        return this.vertexes;
    }

    public final float getU1() {
        return this.u1;
    }

    public final void setU1(float f) {
        this.u1 = f;
    }

    public final float getV1() {
        return this.v1;
    }

    public final void setV1(float f) {
        this.v1 = f;
    }

    public final float getU2() {
        return this.u2;
    }

    public final void setU2(float f) {
        this.u2 = f;
    }

    public final float getV2() {
        return this.v2;
    }

    public final void setV2(float f) {
        this.v2 = f;
    }

    public final float getTextureWidth() {
        return this.textureWidth;
    }

    public final float getTextureHeight() {
        return this.textureHeight;
    }

    public final boolean getMirror() {
        return this.mirror;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final boolean isBoxUv() {
        return this.isBoxUv;
    }

    public final Vector3f getNormal() {
        return this.direction.step();
    }

    @NotNull
    public final OVertex[] component1() {
        return this.vertexes;
    }

    public final float component2() {
        return this.u1;
    }

    public final float component3() {
        return this.v1;
    }

    public final float component4() {
        return this.u2;
    }

    public final float component5() {
        return this.v2;
    }

    public final float component6() {
        return this.textureWidth;
    }

    public final float component7() {
        return this.textureHeight;
    }

    public final boolean component8() {
        return this.mirror;
    }

    @NotNull
    public final Direction component9() {
        return this.direction;
    }

    public final boolean component10() {
        return this.isBoxUv;
    }

    @NotNull
    public final OPolygon copy(@NotNull OVertex[] vertexes, float u1, float v1, float u2, float v2, float textureWidth, float textureHeight, boolean mirror, @NotNull Direction direction2, boolean isBoxUv) {
        Intrinsics.checkNotNullParameter((Object)vertexes, (String)"vertexes");
        Intrinsics.checkNotNullParameter((Object)direction2, (String)"direction");
        return new OPolygon(vertexes, u1, v1, u2, v2, textureWidth, textureHeight, mirror, direction2, isBoxUv);
    }

    public static /* synthetic */ OPolygon copy$default(OPolygon oPolygon, OVertex[] oVertexArray, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, Direction direction2, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            oVertexArray = oPolygon.vertexes;
        }
        if ((n & 2) != 0) {
            f = oPolygon.u1;
        }
        if ((n & 4) != 0) {
            f2 = oPolygon.v1;
        }
        if ((n & 8) != 0) {
            f3 = oPolygon.u2;
        }
        if ((n & 0x10) != 0) {
            f4 = oPolygon.v2;
        }
        if ((n & 0x20) != 0) {
            f5 = oPolygon.textureWidth;
        }
        if ((n & 0x40) != 0) {
            f6 = oPolygon.textureHeight;
        }
        if ((n & 0x80) != 0) {
            bl = oPolygon.mirror;
        }
        if ((n & 0x100) != 0) {
            direction2 = oPolygon.direction;
        }
        if ((n & 0x200) != 0) {
            bl2 = oPolygon.isBoxUv;
        }
        return oPolygon.copy(oVertexArray, f, f2, f3, f4, f5, f6, bl, direction2, bl2);
    }

    @NotNull
    public String toString() {
        return "OPolygon(vertexes=" + Arrays.toString(this.vertexes) + ", u1=" + this.u1 + ", v1=" + this.v1 + ", u2=" + this.u2 + ", v2=" + this.v2 + ", textureWidth=" + this.textureWidth + ", textureHeight=" + this.textureHeight + ", mirror=" + this.mirror + ", direction=" + this.direction + ", isBoxUv=" + this.isBoxUv + ")";
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.vertexes);
        result = result * 31 + Float.hashCode(this.u1);
        result = result * 31 + Float.hashCode(this.v1);
        result = result * 31 + Float.hashCode(this.u2);
        result = result * 31 + Float.hashCode(this.v2);
        result = result * 31 + Float.hashCode(this.textureWidth);
        result = result * 31 + Float.hashCode(this.textureHeight);
        result = result * 31 + Boolean.hashCode(this.mirror);
        result = result * 31 + this.direction.hashCode();
        result = result * 31 + Boolean.hashCode(this.isBoxUv);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OPolygon)) {
            return false;
        }
        OPolygon oPolygon = (OPolygon)other;
        if (!Intrinsics.areEqual((Object)this.vertexes, (Object)oPolygon.vertexes)) {
            return false;
        }
        if (Float.compare(this.u1, oPolygon.u1) != 0) {
            return false;
        }
        if (Float.compare(this.v1, oPolygon.v1) != 0) {
            return false;
        }
        if (Float.compare(this.u2, oPolygon.u2) != 0) {
            return false;
        }
        if (Float.compare(this.v2, oPolygon.v2) != 0) {
            return false;
        }
        if (Float.compare(this.textureWidth, oPolygon.textureWidth) != 0) {
            return false;
        }
        if (Float.compare(this.textureHeight, oPolygon.textureHeight) != 0) {
            return false;
        }
        if (this.mirror != oPolygon.mirror) {
            return false;
        }
        if (this.direction != oPolygon.direction) {
            return false;
        }
        return this.isBoxUv == oPolygon.isBoxUv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcn/solarmoon/spark_core/animation/model/origin/OPolygon$Companion;", "", "<init>", "()V", "of", "Lcn/solarmoon/spark_core/animation/model/origin/OPolygon;", "vertexSet", "Lcn/solarmoon/spark_core/animation/model/origin/OVertexSet;", "cube", "Lcn/solarmoon/spark_core/animation/model/origin/OCube;", "direction", "Lnet/minecraft/core/Direction;", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OPolygon of(@NotNull OVertexSet vertexSet, @NotNull OCube cube, @NotNull Direction direction2) {
            Intrinsics.checkNotNullParameter((Object)vertexSet, (String)"vertexSet");
            Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
            Intrinsics.checkNotNullParameter((Object)direction2, (String)"direction");
            OUVUnion uvUnion = cube.getUvUnion();
            if (uvUnion.isBoxUv()) {
                float u1 = 0.0f;
                float v1 = 0.0f;
                float u2 = 0.0f;
                float v2 = 0.0f;
                Vec2 vec2 = uvUnion.getUv();
                Intrinsics.checkNotNull((Object)vec2);
                Vec2 uv = vec2;
                Vector3f size = cube.getSize().scale(16.0).toVector3f().floor();
                Float[] floatArray = new Float[]{Float.valueOf(uv.x), Float.valueOf(uv.x + size.z), Float.valueOf(uv.x + size.z + size.x), Float.valueOf(uv.x + size.z + size.x + size.x), Float.valueOf(uv.x + size.z + size.x + size.z), Float.valueOf(uv.x + size.z + size.x + size.z + size.x), Float.valueOf(uv.y), Float.valueOf(uv.y + size.z), Float.valueOf(uv.y + size.z + size.y)};
                Float[] uvSet = floatArray;
                switch (WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
                    case 1: {
                        u1 = uvSet[2].floatValue();
                        v1 = uvSet[7].floatValue();
                        u2 = uvSet[4].floatValue();
                        v2 = uvSet[8].floatValue();
                        break;
                    }
                    case 2: {
                        u1 = uvSet[0].floatValue();
                        v1 = uvSet[7].floatValue();
                        u2 = uvSet[1].floatValue();
                        v2 = uvSet[8].floatValue();
                        break;
                    }
                    case 3: {
                        u1 = uvSet[1].floatValue();
                        v1 = uvSet[7].floatValue();
                        u2 = uvSet[2].floatValue();
                        v2 = uvSet[8].floatValue();
                        break;
                    }
                    case 4: {
                        u1 = uvSet[4].floatValue();
                        v1 = uvSet[7].floatValue();
                        u2 = uvSet[5].floatValue();
                        v2 = uvSet[8].floatValue();
                        break;
                    }
                    case 5: {
                        u1 = uvSet[1].floatValue();
                        v1 = uvSet[6].floatValue();
                        u2 = uvSet[2].floatValue();
                        v2 = uvSet[7].floatValue();
                        break;
                    }
                    case 6: {
                        u1 = uvSet[2].floatValue();
                        v1 = uvSet[7].floatValue();
                        u2 = uvSet[3].floatValue();
                        v2 = uvSet[7].floatValue() - size.z;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return new OPolygon(vertexSet.verticesForQuad(direction2, true, cube.getMirror()), u1, v1, u2, v2, cube.getTextureWidth(), cube.getTextureHeight(), cube.getMirror(), direction2, true);
            }
            if (uvUnion.getFaceUV() != null && uvUnion.getFaceUV().get(direction2) != null) {
                OUVUnion.FaceUV faceUV = uvUnion.getFaceUV().get(direction2);
                Intrinsics.checkNotNull((Object)faceUV);
                Vec2 uv = faceUV.getUv();
                OUVUnion.FaceUV faceUV2 = uvUnion.getFaceUV().get(direction2);
                Intrinsics.checkNotNull((Object)faceUV2);
                Vec2 size = faceUV2.getUvSize();
                return new OPolygon(vertexSet.verticesForQuad(direction2, false, cube.getMirror()), uv.x, uv.y, size.x, size.y, cube.getTextureWidth(), cube.getTextureHeight(), cube.getMirror(), direction2, false);
            }
            return new OPolygon(vertexSet.verticesForQuad(direction2, false, cube.getMirror()), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, cube.getMirror(), direction2, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.values().length];
                try {
                    nArray[Direction.WEST.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.EAST.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.NORTH.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.SOUTH.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.UP.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.DOWN.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

