/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.renderer;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.IBlockEntityAnimatable;
import cn.solarmoon.spark_core.animation.renderer.IGeoRenderer;
import cn.solarmoon.spark_core.animation.renderer.layer.RenderLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0005B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ=\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR,\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcn/solarmoon/spark_core/animation/renderer/GeoBlockEntityRenderer;", "B", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lcn/solarmoon/spark_core/animation/IBlockEntityAnimatable;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcn/solarmoon/spark_core/animation/renderer/IGeoRenderer;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "getContext", "()Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "layers", "", "Lcn/solarmoon/spark_core/animation/renderer/layer/RenderLayer;", "getLayers", "()Ljava/util/List;", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "(Lnet/minecraft/world/level/block/entity/BlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nGeoBlockEntityRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoBlockEntityRenderer.kt\ncn/solarmoon/spark_core/animation/renderer/GeoBlockEntityRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public class GeoBlockEntityRenderer<B extends BlockEntity>
implements BlockEntityRenderer<B>,
IGeoRenderer<B, IBlockEntityAnimatable<B>> {
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    @NotNull
    private final List<RenderLayer<B, IBlockEntityAnimatable<B>>> layers;

    public GeoBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.layers = new ArrayList();
    }

    @NotNull
    public final BlockEntityRendererProvider.Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public List<RenderLayer<B, IBlockEntityAnimatable<B>>> getLayers() {
        return this.layers;
    }

    public void render(@NotNull B blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int n;
        Intrinsics.checkNotNullParameter(blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Level level = blockEntity.getLevel();
        if (level != null) {
            Level it = level;
            boolean bl = false;
            n = LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)it), (BlockPos)blockEntity.getBlockPos().above());
        } else {
            n = packedLight;
        }
        int light = n;
        IGeoRenderer.super.render((IAnimatable)blockEntity, partialTick, poseStack, bufferSource, light);
    }
}

