/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.renderer;

import cn.solarmoon.spark_core.animation.ICustomModelItem;
import cn.solarmoon.spark_core.animation.ItemAnimatable;
import cn.solarmoon.spark_core.animation.model.ModelInstance;
import cn.solarmoon.spark_core.animation.model.ModelPose;
import cn.solarmoon.spark_core.animation.model.origin.OModel;
import cn.solarmoon.spark_core.animation.renderer.IGeoRenderer;
import cn.solarmoon.spark_core.animation.renderer.ModelRenderHelperKt;
import cn.solarmoon.spark_core.animation.renderer.layer.RenderLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Brightness;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R&\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcn/solarmoon/spark_core/animation/renderer/GeoItemRenderer;", "Lnet/minecraft/client/renderer/BlockEntityWithoutLevelRenderer;", "Lcn/solarmoon/spark_core/animation/renderer/IGeoRenderer;", "Lnet/minecraft/world/item/ItemStack;", "Lcn/solarmoon/spark_core/animation/ItemAnimatable;", "<init>", "()V", "layers", "", "Lcn/solarmoon/spark_core/animation/renderer/layer/RenderLayer;", "getLayers", "()Ljava/util/List;", "renderByItem", "", "stack", "displayContext", "Lnet/minecraft/world/item/ItemDisplayContext;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "SparkCore-1.21.1-neoforge"})
public class GeoItemRenderer
extends BlockEntityWithoutLevelRenderer
implements IGeoRenderer<ItemStack, ItemAnimatable> {
    @NotNull
    private final List<RenderLayer<ItemStack, ItemAnimatable>> layers = new ArrayList();

    public GeoItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    @Override
    @NotNull
    public List<RenderLayer<ItemStack, ItemAnimatable>> getLayers() {
        return this.layers;
    }

    public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)displayContext, (String)"displayContext");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (stack.getItem() instanceof ICustomModelItem && Minecraft.getInstance().level != null) {
            ClientLevel clientLevel = Minecraft.getInstance().level;
            Intrinsics.checkNotNull((Object)clientLevel);
            ClientLevel level = clientLevel;
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
            Item item = stack.getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type cn.solarmoon.spark_core.animation.ICustomModelItem");
            ICustomModelItem customModelItem = (ICustomModelItem)item;
            ItemAnimatable itemAnimatable = customModelItem.getRenderInstance(stack, (Level)level, displayContext);
            if (itemAnimatable == null) {
                return;
            }
            ItemAnimatable itemAnimatable2 = itemAnimatable;
            poseStack.pushPose();
            if (displayContext == ItemDisplayContext.GUI) {
                poseStack.mulPose(new Quaternionf().rotateY((float)Math.PI));
            }
            ModelInstance modelInstance = itemAnimatable2.getModelController().getModel();
            if (modelInstance != null) {
                ModelInstance model = modelInstance;
                boolean bl = false;
                OModel oModel = model.getOrigin();
                ModelPose modelPose = model.getPose();
                Matrix4f matrix4f = poseStack.last().pose().translate((Vector3fc)customModelItem.getRenderOffset(stack, (Level)level, displayContext)).rotateZYX(customModelItem.getRenderRotation(stack, (Level)level, displayContext)).scale((Vector3fc)customModelItem.getRenderScale(stack, (Level)level, displayContext));
                Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"scale(...)");
                Matrix3f matrix3f = poseStack.last().normal();
                Intrinsics.checkNotNullExpressionValue((Object)matrix3f, (String)"normal(...)");
                VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)model.getTextureLocation()));
                Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
                ModelRenderHelperKt.render(oModel, modelPose, matrix4f, matrix3f, vertexConsumer, Brightness.FULL_BRIGHT.pack(), packedOverlay, customModelItem.getColor(stack, (Level)level, displayContext).getRGB(), partialTicks, true);
            }
            poseStack.popPose();
        }
    }
}

