/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.renderer;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.renderer.IGeoRenderer;
import cn.solarmoon.spark_core.animation.renderer.layer.RenderLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0006:\u0001$B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ=\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u001d\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010#R&\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcn/solarmoon/spark_core/animation/renderer/GeoLivingEntityRenderer;", "T", "Lnet/minecraft/world/entity/LivingEntity;", "Lcn/solarmoon/spark_core/animation/IEntityAnimatable;", "Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;", "Lnet/minecraft/client/model/EntityModel;", "Lcn/solarmoon/spark_core/animation/renderer/IGeoRenderer;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "shadowRadius", "", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;F)V", "layers", "", "Lcn/solarmoon/spark_core/animation/renderer/layer/RenderLayer;", "getLayers", "()Ljava/util/List;", "render", "", "animatable", "yaw", "partialTick", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "entity", "(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/resources/ResourceLocation;", "getOverlay", "(Lnet/minecraft/world/entity/LivingEntity;F)I", "EmptyModel", "SparkCore-1.21.1-neoforge"})
public class GeoLivingEntityRenderer<T extends LivingEntity>
extends LivingEntityRenderer<T, EntityModel<T>>
implements IGeoRenderer<T, T> {
    @NotNull
    private final List<RenderLayer<T, T>> layers;

    public GeoLivingEntityRenderer(@NotNull EntityRendererProvider.Context context, float shadowRadius) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, (EntityModel)new EmptyModel(), shadowRadius);
        this.layers = new ArrayList();
    }

    @Override
    @NotNull
    public List<RenderLayer<T, T>> getLayers() {
        return this.layers;
    }

    public void render(@NotNull T animatable, float yaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        super.render(animatable, yaw, partialTick, poseStack, bufferSource, packedLight);
        IGeoRenderer.super.render((IAnimatable)animatable, partialTick, poseStack, bufferSource, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        return this.getGeoTextureLocation((IAnimatable)entity);
    }

    @Override
    public int getOverlay(@NotNull T entity, float partialTick) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        return LivingEntityRenderer.getOverlayCoords(entity, (float)this.getWhiteOverlayProgress((LivingEntity)entity, partialTick));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J=\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ0\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016\u00a8\u0006\u0019"}, d2={"Lcn/solarmoon/spark_core/animation/renderer/GeoLivingEntityRenderer$EmptyModel;", "T", "Lnet/minecraft/world/entity/Entity;", "Lnet/minecraft/client/model/EntityModel;", "<init>", "()V", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "(Lnet/minecraft/world/entity/Entity;FFFFF)V", "renderToBuffer", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "", "packedOverlay", "color", "SparkCore-1.21.1-neoforge"})
    public static final class EmptyModel<T extends Entity>
    extends EntityModel<T> {
        public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
        }

        public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        }
    }
}

