/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.renderer;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.renderer.ModelRenderHelperKt;
import cn.solarmoon.spark_core.animation.renderer.layer.RenderLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Quaternionf;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004J5\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00142\u0006\u0010\f\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eR$\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001f\u00c0\u0006\u0001"}, d2={"Lcn/solarmoon/spark_core/animation/renderer/IGeoRenderer;", "T", "S", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "", "layers", "", "Lcn/solarmoon/spark_core/animation/renderer/layer/RenderLayer;", "getLayers", "()Ljava/util/List;", "render", "", "animatable", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "(Lcn/solarmoon/spark_core/animation/IAnimatable;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "getColor", "(Lcn/solarmoon/spark_core/animation/IAnimatable;F)I", "getOverlay", "getRenderType", "Lnet/minecraft/client/renderer/RenderType;", "(Lcn/solarmoon/spark_core/animation/IAnimatable;)Lnet/minecraft/client/renderer/RenderType;", "getGeoTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "(Lcn/solarmoon/spark_core/animation/IAnimatable;)Lnet/minecraft/resources/ResourceLocation;", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nIGeoRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IGeoRenderer.kt\ncn/solarmoon/spark_core/animation/renderer/IGeoRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1869#2,2:48\n*S KotlinDebug\n*F\n+ 1 IGeoRenderer.kt\ncn/solarmoon/spark_core/animation/renderer/IGeoRenderer\n*L\n32#1:48,2\n*E\n"})
public interface IGeoRenderer<T, S extends IAnimatable<T>> {
    @NotNull
    public List<RenderLayer<T, S>> getLayers();

    default public void render(@NotNull S animatable, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        VertexConsumer buffer = bufferSource.getBuffer(this.getRenderType(animatable));
        int overlay = this.getOverlay(animatable, partialTick);
        poseStack.pushPose();
        poseStack.mulPose(new Quaternionf().rotateY((float)Math.PI));
        poseStack.popPose();
        Matrix3f matrix3f = poseStack.last().normal();
        Intrinsics.checkNotNullExpressionValue((Object)matrix3f, (String)"normal(...)");
        Intrinsics.checkNotNull((Object)buffer);
        ModelRenderHelperKt.render(animatable, matrix3f, buffer, packedLight, overlay, this.getColor(animatable, partialTick), partialTick);
        Iterable $this$forEach$iv = this.getLayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderLayer it = (RenderLayer)element$iv;
            boolean bl = false;
            it.render(animatable, partialTick, poseStack, bufferSource, packedLight, -1);
        }
    }

    default public int getColor(@NotNull S animatable, float partialTick) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        return -1;
    }

    default public int getOverlay(@NotNull S animatable, float partialTick) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        return OverlayTexture.NO_OVERLAY;
    }

    @NotNull
    default public RenderType getRenderType(@NotNull S animatable) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        RenderType renderType = RenderType.entityTranslucent((ResourceLocation)this.getGeoTextureLocation(animatable));
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"entityTranslucent(...)");
        return renderType;
    }

    @NotNull
    default public ResourceLocation getGeoTextureLocation(@NotNull S animatable) {
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        ResourceLocation resourceLocation = animatable.getModelController().getTextureLocation();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-textureLocation>(...)");
        return resourceLocation;
    }
}

