/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.renderer.layer;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.renderer.ModelRenderHelperKt;
import cn.solarmoon.spark_core.animation.renderer.layer.RenderLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ=\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcn/solarmoon/spark_core/animation/renderer/layer/GlowingTextureLayer;", "T", "S", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "Lcn/solarmoon/spark_core/animation/renderer/layer/RenderLayer;", "<init>", "()V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "sth", "(Lcn/solarmoon/spark_core/animation/IAnimatable;)Lnet/minecraft/resources/ResourceLocation;", "getRenderType", "Lnet/minecraft/client/renderer/RenderType;", "(Lcn/solarmoon/spark_core/animation/IAnimatable;)Lnet/minecraft/client/renderer/RenderType;", "render", "", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "(Lcn/solarmoon/spark_core/animation/IAnimatable;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "SparkCore-1.21.1-neoforge"})
public class GlowingTextureLayer<T, S extends IAnimatable<T>>
extends RenderLayer<T, S> {
    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull S sth) {
        Intrinsics.checkNotNullParameter(sth, (String)"sth");
        ResourceLocation resourceLocation = sth.getModelController().getTextureLocation();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-textureLocation>(...)");
        return resourceLocation;
    }

    @Override
    @NotNull
    public RenderType getRenderType(@NotNull S sth) {
        Intrinsics.checkNotNullParameter(sth, (String)"sth");
        RenderType renderType = RenderType.eyes((ResourceLocation)this.getTextureLocation(sth));
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"eyes(...)");
        return renderType;
    }

    @Override
    public void render(@NotNull S sth, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter(sth, (String)"sth");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        VertexConsumer buffer = bufferSource.getBuffer(this.getRenderType(sth));
        poseStack.pushPose();
        int overlay = OverlayTexture.NO_OVERLAY;
        Matrix3f matrix3f = poseStack.last().normal();
        Intrinsics.checkNotNullExpressionValue((Object)matrix3f, (String)"normal(...)");
        Intrinsics.checkNotNull((Object)buffer);
        ModelRenderHelperKt.render(sth, matrix3f, buffer, packedLight, overlay, -1, partialTick);
        poseStack.popPose();
    }
}

