/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.animation.vanilla;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.anim.KeyAnimData;
import cn.solarmoon.spark_core.event.BoneUpdateEvent;
import cn.solarmoon.spark_core.util.SparkMathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcn/solarmoon/spark_core/animation/vanilla/BoneModifier;", "", "<init>", "()V", "head", "", "event", "Lcn/solarmoon/spark_core/event/BoneUpdateEvent;", "sleep", "sleepDirectionToRotation", "", "facing", "Lnet/minecraft/core/Direction;", "SparkCore-1.21.1-neoforge"})
public final class BoneModifier {
    @NotNull
    public static final BoneModifier INSTANCE = new BoneModifier();

    private BoneModifier() {
    }

    @SubscribeEvent
    private final void head(BoneUpdateEvent event) {
        IAnimatable<?> player = event.getModel().getAnimatable();
        if (!(player instanceof IEntityAnimatable) || !(player instanceof LivingEntity)) {
            return;
        }
        KeyAnimData old = event.getOldTransform();
        if (Intrinsics.areEqual((Object)event.getBonePose().getName(), (Object)"head")) {
            Vec3 vec3 = old.getPosition();
            Vec3 vec32 = event.getOriginNewTransform().getRotation().add(SparkMathKt.toRadians(new Vec3(-((double)((Entity)player).getXRot()), (double)(-((LivingEntity)player).yHeadRot + ((LivingEntity)player).yBodyRot), 0.0)));
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
            event.setNewTransform(new KeyAnimData(vec3, vec32, old.getScale()));
        }
    }

    @SubscribeEvent
    private final void sleep(BoneUpdateEvent event) {
        Direction bedDirection;
        IAnimatable<?> animatable = event.getModel().getAnimatable();
        if (Intrinsics.areEqual((Object)event.getBonePose().getName(), (Object)"root") && animatable instanceof LivingEntity && (bedDirection = ((LivingEntity)animatable).getBedOrientation()) != null && ((LivingEntity)animatable).isSleeping()) {
            KeyAnimData old = event.getOriginNewTransform();
            double bedRotation = SparkMathKt.toRadians(this.sleepDirectionToRotation(bedDirection));
            double f3 = (double)((Entity)animatable).getEyeHeight(Pose.STANDING) - 1.2;
            Vec3 offset = new Vec3(f3 * (double)bedDirection.getStepX(), 0.0, f3 * (double)bedDirection.getStepZ()).yRot(SparkMathKt.toRadians(((LivingEntity)animatable).yBodyRot));
            event.setNewTransform(new KeyAnimData(new Vec3(old.getPosition().x + offset.x, old.getPosition().y, old.getPosition().z + offset.z), new Vec3(old.getRotation().x, old.getRotation().y + (double)SparkMathKt.toRadians(((LivingEntity)animatable).yBodyRot) + Math.PI + bedRotation, old.getRotation().z), old.getScale()));
        }
    }

    public final double sleepDirectionToRotation(@NotNull Direction facing) {
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        return switch (WhenMappings.$EnumSwitchMapping$0[facing.ordinal()]) {
            case 1 -> 0.0;
            case 2 -> 270.0;
            case 3 -> 180.0;
            case 4 -> 90.0;
            default -> 0.0;
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

