/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.command;

import cn.solarmoon.spark_core.command.AbilityCommand;
import cn.solarmoon.spark_core.gas.AbilityHandle;
import cn.solarmoon.spark_core.gas.AbilitySpec;
import cn.solarmoon.spark_core.gas.AbilitySystemComponent;
import cn.solarmoon.spark_core.gas.ActivationContext;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcn/solarmoon/spark_core/command/PlayAbilityCommand;", "Lcn/solarmoon/spark_core/command/AbilityCommand;", "<init>", "()V", "skillSuggestions", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "Lnet/minecraft/commands/CommandSourceStack;", "putExecution", "", "context", "Lnet/minecraft/commands/CommandBuildContext;", "executePlaySkill", "", "Lcom/mojang/brigadier/context/CommandContext;", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nPlayAbilityCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayAbilityCommand.kt\ncn/solarmoon/spark_core/command/PlayAbilityCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1563#2:106\n1634#2,3:107\n*S KotlinDebug\n*F\n+ 1 PlayAbilityCommand.kt\ncn/solarmoon/spark_core/command/PlayAbilityCommand\n*L\n29#1:106\n29#1:107,3\n*E\n"})
public final class PlayAbilityCommand
extends AbilityCommand {
    @NotNull
    private final SuggestionProvider<CommandSourceStack> skillSuggestions = PlayAbilityCommand::skillSuggestions$lambda$2;

    public PlayAbilityCommand() {
        super(2);
    }

    @Override
    protected void putExecution(@NotNull CommandBuildContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.getBuilder().then(Commands.literal((String)"play").then(Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.entity())).then(((RequiredArgumentBuilder)Commands.argument((String)"ability", (ArgumentType)((ArgumentType)StringArgumentType.string())).suggests(this.skillSuggestions).executes(arg_0 -> PlayAbilityCommand.putExecution$lambda$3(this, arg_0))).then(Commands.argument((String)"activation_context", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(arg_0 -> PlayAbilityCommand.putExecution$lambda$4(this, arg_0))))));
    }

    private final int executePlaySkill(CommandContext<CommandSourceStack> context) {
        Entity entity;
        String string;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String raw = StringArgumentType.getString(context, (String)"ability");
        try {
            string = StringArgumentType.getString(context, (String)"activation_context");
        }
        catch (Exception e) {
            string = "";
        }
        String nbt = string;
        Regex regex = new Regex("\\[(\\d+)](.+)");
        Intrinsics.checkNotNull((Object)raw);
        MatchResult match = regex.matchEntire((CharSequence)raw);
        if (match == null) {
            source.sendFailure((Component)Component.literal((String)("\u65e0\u6548\u7684\u6280\u80fd\u53c2\u6570: " + raw)));
            return 0;
        }
        int handleId = Integer.parseInt((String)match.getGroupValues().get(1));
        String skillKey = (String)match.getGroupValues().get(2);
        try {
            entity = EntityArgument.getEntity(context, (String)"target");
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.translatable((String)"command.spark_core.skill.play.invalid_target"));
            return 0;
        }
        Entity target = entity;
        AbilitySystemComponent abilitySystemComponent = target.getAbilitySystemComponent();
        Intrinsics.checkNotNullExpressionValue((Object)abilitySystemComponent, (String)"<get-abilitySystemComponent>(...)");
        AbilitySystemComponent asc = abilitySystemComponent;
        AbilitySpec<?> spec = asc.findSpecFromHandle(new AbilityHandle(handleId));
        if (spec == null) {
            Object[] objectArray = new Object[]{skillKey};
            source.sendFailure((Component)Component.translatable((String)"command.spark_core.skill.play.unknown", (Object[])objectArray));
            return 0;
        }
        Ref.IntRef successCount = new Ref.IntRef();
        Intrinsics.checkNotNull((Object)nbt);
        ActivationContext activationContext = ((CharSequence)nbt).length() == 0 ? (ActivationContext)ActivationContext.Empty.INSTANCE : (ActivationContext)((Pair)ActivationContext.Companion.getCODEC().decode((DynamicOps)NbtOps.INSTANCE, (Object)TagParser.parseTag((String)nbt)).getOrThrow()).getFirst();
        AbilityHandle abilityHandle = spec.getHandle();
        Intrinsics.checkNotNull((Object)activationContext);
        if (asc.tryActivateAbility(abilityHandle, activationContext)) {
            int n = successCount.element;
            successCount.element = n + 1;
        }
        if (successCount.element == 0) {
            source.sendFailure((Component)Component.translatable((String)"command.spark_core.skill.play.no_target"));
        } else {
            source.sendSuccess(() -> PlayAbilityCommand.executePlaySkill$lambda$5(skillKey, successCount), true);
        }
        return successCount.element;
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture skillSuggestions$lambda$2(CommandContext context, SuggestionsBuilder builder) {
        CompletableFuture completableFuture;
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity != null) {
            void $this$mapTo$iv$iv;
            Entity entity2 = entity;
            boolean bl = false;
            Iterable $this$map$iv = entity2.getAbilitySystemComponent().getAllAbilitySpecs().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void spec;
                AbilitySpec abilitySpec = (AbilitySpec)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add("'[" + spec.getHandle().getId() + "]" + spec.getAbilityType().getRegistryKey() + "'");
            }
            completableFuture = SharedSuggestionProvider.suggest((Iterable)((List)destination$iv$iv), (SuggestionsBuilder)builder);
        } else {
            completableFuture = null;
        }
        return completableFuture;
    }

    private static final int putExecution$lambda$3(PlayAbilityCommand this$0, CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.executePlaySkill((CommandContext<CommandSourceStack>)it);
    }

    private static final int putExecution$lambda$4(PlayAbilityCommand this$0, CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.executePlaySkill((CommandContext<CommandSourceStack>)it);
    }

    private static final Component executePlaySkill$lambda$5(String $skillKey, Ref.IntRef $successCount) {
        Object[] objectArray = new Object[]{$skillKey, $successCount.element};
        return (Component)Component.translatable((String)"command.spark_core.skill.play.success", (Object[])objectArray);
    }
}

