/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.delta_sync;

import cn.solarmoon.spark_core.delta_sync.DiffSyncSchema;
import cn.solarmoon.spark_core.delta_sync.FieldDef;
import cn.solarmoon.spark_core.registry.common.SparkRegistries;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u0012\u001a\u00020\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u0015\u00a2\u0006\u0002\b\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bH\u00c6\u0003J9\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lcn/solarmoon/spark_core/delta_sync/DiffPacket;", "", "schemaId", "", "mask", "", "nullMask", "values", "", "<init>", "(SJJLjava/util/List;)V", "getSchemaId", "()S", "getMask", "()J", "getNullMask", "getValues", "()Ljava/util/List;", "ifValid", "", "consumer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "SparkCore-1.21.1-neoforge"})
public final class DiffPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final short schemaId;
    private final long mask;
    private final long nullMask;
    @NotNull
    private final List<Object> values;
    private static final StreamCodec<ByteBuf, DiffPacket> STREAM_CODEC = NeoForgeStreamCodecs.lazy(DiffPacket::STREAM_CODEC$lambda$0);

    public DiffPacket(short schemaId, long mask, long nullMask, @NotNull List<? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.schemaId = schemaId;
        this.mask = mask;
        this.nullMask = nullMask;
        this.values = values;
    }

    public final short getSchemaId() {
        return this.schemaId;
    }

    public final long getMask() {
        return this.mask;
    }

    public final long getNullMask() {
        return this.nullMask;
    }

    @NotNull
    public final List<Object> getValues() {
        return this.values;
    }

    public final void ifValid(@NotNull Function1<? super DiffPacket, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.mask != 0L) {
            consumer.invoke((Object)this);
        }
    }

    public final short component1() {
        return this.schemaId;
    }

    public final long component2() {
        return this.mask;
    }

    public final long component3() {
        return this.nullMask;
    }

    @NotNull
    public final List<Object> component4() {
        return this.values;
    }

    @NotNull
    public final DiffPacket copy(short schemaId, long mask, long nullMask, @NotNull List<? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new DiffPacket(schemaId, mask, nullMask, values);
    }

    public static /* synthetic */ DiffPacket copy$default(DiffPacket diffPacket, short s, long l, long l2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            s = diffPacket.schemaId;
        }
        if ((n & 2) != 0) {
            l = diffPacket.mask;
        }
        if ((n & 4) != 0) {
            l2 = diffPacket.nullMask;
        }
        if ((n & 8) != 0) {
            list = diffPacket.values;
        }
        return diffPacket.copy(s, l, l2, list);
    }

    @NotNull
    public String toString() {
        return "DiffPacket(schemaId=" + this.schemaId + ", mask=" + this.mask + ", nullMask=" + this.nullMask + ", values=" + this.values + ")";
    }

    public int hashCode() {
        int result = Short.hashCode(this.schemaId);
        result = result * 31 + Long.hashCode(this.mask);
        result = result * 31 + Long.hashCode(this.nullMask);
        result = result * 31 + ((Object)this.values).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DiffPacket)) {
            return false;
        }
        DiffPacket diffPacket = (DiffPacket)other;
        if (this.schemaId != diffPacket.schemaId) {
            return false;
        }
        if (this.mask != diffPacket.mask) {
            return false;
        }
        if (this.nullMask != diffPacket.nullMask) {
            return false;
        }
        return Intrinsics.areEqual(this.values, diffPacket.values);
    }

    private static final StreamCodec STREAM_CODEC$lambda$0() {
        return (StreamCodec)new StreamCodec<ByteBuf, DiffPacket>(){

            public void encode(ByteBuf buf, DiffPacket packet) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                Object object = SparkRegistries.getDIFF_SYNC_SCHEMA().byId((int)packet.getSchemaId());
                Intrinsics.checkNotNull((Object)object);
                DiffSyncSchema schema = (DiffSyncSchema)object;
                buf.writeShort((int)packet.getSchemaId());
                buf.writeLong(packet.getMask());
                buf.writeLong(packet.getNullMask());
                int index = 0;
                for (FieldDef<?, D> field : schema.getFields()) {
                    StreamCodec<ByteBuf, ?> codec2;
                    if ((packet.getMask() & field.getMaskBit()) == 0L) continue;
                    boolean isNull = (packet.getNullMask() & field.getMaskBit()) != 0L;
                    Object value = packet.getValues().get(index++);
                    if (isNull || value == null) continue;
                    Intrinsics.checkNotNull(field.getCodec(), (String)"null cannot be cast to non-null type net.minecraft.network.codec.StreamCodec<io.netty.buffer.ByteBuf, kotlin.Any?>");
                    codec2.encode((Object)buf, value);
                }
            }

            public DiffPacket decode(ByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                short schemaId = buf.readShort();
                Object object = SparkRegistries.getDIFF_SYNC_SCHEMA().byId((int)schemaId);
                Intrinsics.checkNotNull((Object)object);
                DiffSyncSchema schema = (DiffSyncSchema)object;
                long mask = buf.readLong();
                long nullMask = buf.readLong();
                List values = new ArrayList<E>();
                for (FieldDef<?, D> field : schema.getFields()) {
                    boolean bl;
                    boolean isNull;
                    if ((mask & field.getMaskBit()) == 0L) continue;
                    boolean bl2 = isNull = (nullMask & field.getMaskBit()) != 0L;
                    if (isNull) {
                        bl = values.add(null);
                        continue;
                    }
                    StreamCodec<ByteBuf, ?> codec2 = field.getCodec();
                    Object value = codec2.decode((Object)buf);
                    bl = values.add(value);
                }
                return new DiffPacket(schemaId, mask, nullMask, values);
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003RS\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcn/solarmoon/spark_core/delta_sync/DiffPacket$Companion;", "", "<init>", "()V", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "Lcn/solarmoon/spark_core/delta_sync/DiffPacket;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/codec/StreamCodec;", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public final StreamCodec<ByteBuf, DiffPacket> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

