/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.delta_sync;

import cn.solarmoon.spark_core.delta_sync.DiffPacket;
import cn.solarmoon.spark_core.delta_sync.DiffSnapshot;
import cn.solarmoon.spark_core.delta_sync.FieldDef;
import cn.solarmoon.spark_core.registry.common.SparkRegistries;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001f\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eR!\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcn/solarmoon/spark_core/delta_sync/DiffSyncSchema;", "D", "", "fields", "", "Lcn/solarmoon/spark_core/delta_sync/FieldDef;", "<init>", "(Ljava/util/List;)V", "getFields", "()Ljava/util/List;", "id", "", "getId", "()I", "diffMask", "", "oldSnapshot", "Lcn/solarmoon/spark_core/delta_sync/DiffSnapshot;", "newObj", "(Lcn/solarmoon/spark_core/delta_sync/DiffSnapshot;Ljava/lang/Object;)J", "diffPacket", "Lcn/solarmoon/spark_core/delta_sync/DiffPacket;", "(Lcn/solarmoon/spark_core/delta_sync/DiffSnapshot;Ljava/lang/Object;)Lcn/solarmoon/spark_core/delta_sync/DiffPacket;", "applyDiff", "", "diff", "target", "(Lcn/solarmoon/spark_core/delta_sync/DiffPacket;Ljava/lang/Object;)V", "snapshotFrom", "obj", "(Ljava/lang/Object;)Lcn/solarmoon/spark_core/delta_sync/DiffSnapshot;", "SparkCore-1.21.1-neoforge"})
public final class DiffSyncSchema<D> {
    @NotNull
    private final List<FieldDef<?, D>> fields;

    public DiffSyncSchema(@NotNull List<? extends FieldDef<?, D>> fields) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.fields = fields;
    }

    @NotNull
    public final List<FieldDef<?, D>> getFields() {
        return this.fields;
    }

    public final int getId() {
        return SparkRegistries.getDIFF_SYNC_SCHEMA().getId((Object)this);
    }

    public final long diffMask(@NotNull DiffSnapshot oldSnapshot, @NotNull D newObj) {
        Intrinsics.checkNotNullParameter((Object)oldSnapshot, (String)"oldSnapshot");
        Intrinsics.checkNotNullParameter(newObj, (String)"newObj");
        long mask = 0L;
        for (FieldDef<?, D> field : this.fields) {
            Object oldVal = oldSnapshot.getValues().get(field.getMaskBit());
            Object newVal = field.getExtract().invoke(newObj);
            Function2<?, ?, Boolean> function2 = field.getHasChanged();
            Intrinsics.checkNotNull(function2, (String)"null cannot be cast to non-null type kotlin.Function2<kotlin.Any?, kotlin.Any?, kotlin.Boolean>");
            Function2 checker = (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(function2, (int)2);
            if (!((Boolean)checker.invoke(oldVal, newVal)).booleanValue()) continue;
            mask |= field.getMaskBit();
        }
        return mask;
    }

    @NotNull
    public final DiffPacket diffPacket(@NotNull DiffSnapshot oldSnapshot, @NotNull D newObj) {
        Intrinsics.checkNotNullParameter((Object)oldSnapshot, (String)"oldSnapshot");
        Intrinsics.checkNotNullParameter(newObj, (String)"newObj");
        long mask = 0L;
        long nullMask = 0L;
        List values = new ArrayList();
        for (FieldDef<?, D> field : this.fields) {
            boolean bl;
            Object oldVal = oldSnapshot.getValues().get(field.getMaskBit());
            Object newVal = field.getExtract().invoke(newObj);
            Function2<?, ?, Boolean> function2 = field.getHasChanged();
            Intrinsics.checkNotNull(function2, (String)"null cannot be cast to non-null type kotlin.Function2<kotlin.Any?, kotlin.Any?, kotlin.Boolean>");
            Function2 checker = (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(function2, (int)2);
            if (!((Boolean)checker.invoke(oldVal, newVal)).booleanValue()) continue;
            mask |= field.getMaskBit();
            if (newVal == null) {
                nullMask |= field.getMaskBit();
                bl = values.add(null);
                continue;
            }
            bl = values.add(newVal);
        }
        if (mask == 0L) {
            return new DiffPacket((short)this.getId(), 0L, 0L, CollectionsKt.emptyList());
        }
        return new DiffPacket((short)this.getId(), mask, nullMask, values);
    }

    public final void applyDiff(@NotNull DiffPacket diff, @NotNull D target) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        int index = 0;
        for (FieldDef<?, D> field : this.fields) {
            if ((diff.getMask() & field.getMaskBit()) == 0L) continue;
            boolean isNull = (diff.getNullMask() & field.getMaskBit()) != 0L;
            Object value = diff.getValues().get(index++);
            if (isNull || value == null) continue;
            Function2<D, ?, Unit> function2 = field.getApply();
            Intrinsics.checkNotNull(function2, (String)"null cannot be cast to non-null type kotlin.Function2<D of cn.solarmoon.spark_core.delta_sync.DiffSyncSchema, kotlin.Any, kotlin.Unit>");
            ((Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(function2, (int)2)).invoke(target, value);
        }
    }

    @NotNull
    public final DiffSnapshot snapshotFrom(@NotNull D obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Map snap = new LinkedHashMap();
        for (FieldDef<?, D> field : this.fields) {
            snap.put(field.getMaskBit(), field.getExtract().invoke(obj));
        }
        return new DiffSnapshot(snap);
    }
}

