/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.entity;

import cn.solarmoon.spark_core.util.Side;
import cn.solarmoon.spark_core.util.SparkMathKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001*\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0003\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0003\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\u0003\u001a$\u0010\u000b\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0001\u001a\u001c\u0010\u0013\u001a\u00020\u0012*\u00020\u00032\u0006\u0010\f\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0006\u001a\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\u0010\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\t\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0010\u001a\u0012\u0010\u001e\u001a\u00020\u0010*\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0010\u001a\u001a\u0010 \u001a\u00020\u0016*\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u000e\u001a\u001a\u0010$\u001a\u00020\u0016*\u00020!2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u000e\u001a\u001a\u0010&\u001a\u00020\u0016*\u00020\u00032\u0006\u0010%\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0001\u001a\n\u0010(\u001a\u00020)*\u00020)\u001a\u0012\u0010*\u001a\u00020\u0006*\u00020\u00032\u0006\u0010+\u001a\u00020\u000e\u00a8\u0006,"}, d2={"groundMovement", "Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/entity/Entity;", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/Vec3;", "moveCheck", "", "moveBackCheck", "isMoving", "Lnet/minecraft/client/player/LocalPlayer;", "isFalling", "canSee", "targetPos", "rangeDegrees", "", "rotateY", "", "getSide", "Lcn/solarmoon/spark_core/util/Side;", "getLateralSide", "invert", "smoothLookAt", "", "target", "partialTicks", "getInputVector", "getRelativeVector", "v", "getForwardMoveVector", "mul", "getAttackAnimSpeed", "baseSpeedValue", "knockBackRelativeView", "Lnet/minecraft/world/entity/LivingEntity;", "attacker", "strength", "knockBackRelative", "relative", "addRelativeMovement", "move", "copy", "Lnet/minecraft/client/player/Input;", "isAboveGround", "minDistance", "SparkCore-1.21.1-neoforge"})
public final class EntityStateHelperKt {
    public static final Vec3 groundMovement(@NotNull Entity $this$groundMovement) {
        Intrinsics.checkNotNullParameter((Object)$this$groundMovement, (String)"<this>");
        return $this$groundMovement.position().subtract($this$groundMovement.getLastPosO());
    }

    public static final boolean moveCheck(@NotNull Entity $this$moveCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$moveCheck, (String)"<this>");
        Vec3 v = EntityStateHelperKt.groundMovement($this$moveCheck);
        double avgV = (Math.abs(v.x) + Math.abs(v.z)) / (double)2.0f;
        return avgV >= 0.015;
    }

    public static final boolean moveBackCheck(@NotNull Entity $this$moveBackCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$moveBackCheck, (String)"<this>");
        Vec3 v = EntityStateHelperKt.groundMovement($this$moveBackCheck);
        Vec3 forward = Vec3.directionFromRotation((float)0.0f, (float)$this$moveBackCheck.getPreciseBodyRotation(1.0f));
        double dotProduct = v.normalize().x * forward.normalize().x + v.normalize().z * forward.normalize().z;
        return dotProduct < (double)((float)Math.cos(SparkMathKt.toRadians(120.0f)));
    }

    public static final boolean isMoving(@NotNull LocalPlayer $this$isMoving) {
        Intrinsics.checkNotNullParameter((Object)$this$isMoving, (String)"<this>");
        return $this$isMoving.input != null && $this$isMoving.input.getMoveVector().length() > 0.0f;
    }

    public static final boolean isFalling(@NotNull Entity $this$isFalling) {
        Intrinsics.checkNotNullParameter((Object)$this$isFalling, (String)"<this>");
        return !$this$isFalling.onGround() && !(EntityStateHelperKt.groundMovement((Entity)$this$isFalling).y == 0.0) && (!($this$isFalling instanceof Player) || !((Player)$this$isFalling).getAbilities().flying);
    }

    public static final boolean canSee(@NotNull Entity $this$canSee, @NotNull Vec3 targetPos, double rangeDegrees, float rotateY) {
        Intrinsics.checkNotNullParameter((Object)$this$canSee, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
        Vec3 entityPos = $this$canSee.position();
        Vector3f vector3f = Vec3.directionFromRotation((float)0.0f, (float)$this$canSee.getYRot()).toVector3f().rotateY(SparkMathKt.toRadians(rotateY));
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"rotateY(...)");
        Vec3 viewVector = SparkMathKt.toVec3(vector3f);
        Vec3 directionToTarget = targetPos.subtract(entityPos).normalize();
        double dotProduct = viewVector.dot(directionToTarget);
        double thresholdCosAngle = Math.cos(Math.toRadians(rangeDegrees / (double)2));
        return dotProduct > thresholdCosAngle;
    }

    public static /* synthetic */ boolean canSee$default(Entity entity, Vec3 vec3, double d, float f, int n, Object object) {
        if ((n & 4) != 0) {
            f = 0.0f;
        }
        return EntityStateHelperKt.canSee(entity, vec3, d, f);
    }

    @NotNull
    public static final Side getSide(@NotNull Entity $this$getSide, @NotNull Vec3 targetPos) {
        Intrinsics.checkNotNullParameter((Object)$this$getSide, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
        return EntityStateHelperKt.canSee($this$getSide, targetPos, 135.0, 0.0f) ? Side.FRONT : (EntityStateHelperKt.canSee($this$getSide, targetPos, 45.0, 90.0f) ? Side.LEFT : (EntityStateHelperKt.canSee($this$getSide, targetPos, 135.0, 180.0f) ? Side.BACK : (EntityStateHelperKt.canSee($this$getSide, targetPos, 45.0, 270.0f) ? Side.RIGHT : Side.FRONT)));
    }

    @NotNull
    public static final Side getLateralSide(@NotNull Entity $this$getLateralSide, @NotNull Vec3 targetPos, boolean invert) {
        Intrinsics.checkNotNullParameter((Object)$this$getLateralSide, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
        return EntityStateHelperKt.canSee($this$getLateralSide, targetPos, 180.0, 90.0f) ? (!invert ? Side.LEFT : Side.RIGHT) : (EntityStateHelperKt.canSee($this$getLateralSide, targetPos, 180.0, 270.0f) ? (!invert ? Side.RIGHT : Side.LEFT) : Side.RIGHT);
    }

    public static /* synthetic */ Side getLateralSide$default(Entity entity, Vec3 vec3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return EntityStateHelperKt.getLateralSide(entity, vec3, bl);
    }

    public static final void smoothLookAt(@NotNull Entity $this$smoothLookAt, @NotNull Vec3 target, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)$this$smoothLookAt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.apply($this$smoothLookAt);
        double d0 = target.x - vec3.x;
        double d1 = target.y - vec3.y;
        double d2 = target.z - vec3.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        $this$smoothLookAt.setXRot(Mth.rotLerp((float)partialTicks, (float)$this$smoothLookAt.xRotO, (float)((float)Mth.wrapDegrees((double)(-(Mth.atan2((double)d1, (double)d3) * (double)180.0f / Math.PI))))));
        $this$smoothLookAt.setYRot(Mth.rotLerp((float)partialTicks, (float)$this$smoothLookAt.yRotO, (float)((float)Mth.wrapDegrees((double)(Mth.atan2((double)d2, (double)d0) * (double)180.0f / Math.PI - (double)90.0f)))));
    }

    public static /* synthetic */ void smoothLookAt$default(Entity entity, Vec3 vec3, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        EntityStateHelperKt.smoothLookAt(entity, vec3, f);
    }

    @NotNull
    public static final Vec3 getInputVector(@NotNull LocalPlayer $this$getInputVector) {
        Intrinsics.checkNotNullParameter((Object)$this$getInputVector, (String)"<this>");
        Vec2 v = $this$getInputVector.input.getMoveVector().normalized();
        float f2 = v.x;
        float f3 = v.y;
        double f4 = Math.sin((double)$this$getInputVector.getYRot() * (Math.PI / 180));
        double f5 = Math.cos((double)$this$getInputVector.getYRot() * (Math.PI / 180));
        return new Vec3((double)f2 * f5 - (double)f3 * f4, $this$getInputVector.getDeltaMovement().y, (double)f3 * f5 + (double)f2 * f4);
    }

    @NotNull
    public static final Vec3 getRelativeVector(@NotNull Entity $this$getRelativeVector, @NotNull Vec3 v) {
        Intrinsics.checkNotNullParameter((Object)$this$getRelativeVector, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double f2 = v.x;
        double f3 = v.z;
        double f4 = Math.sin((double)$this$getRelativeVector.getYRot() * (Math.PI / 180));
        double f5 = Math.cos((double)$this$getRelativeVector.getYRot() * (Math.PI / 180));
        return new Vec3(f2 * f5 - f3 * f4, v.y, f3 * f5 + f2 * f4);
    }

    @NotNull
    public static final Vec3 getForwardMoveVector(@NotNull Entity $this$getForwardMoveVector, float mul) {
        Intrinsics.checkNotNullParameter((Object)$this$getForwardMoveVector, (String)"<this>");
        return new Vec3($this$getForwardMoveVector.getForward().x * (double)mul, $this$getForwardMoveVector.getDeltaMovement().y, $this$getForwardMoveVector.getForward().z * (double)mul);
    }

    public static final float getAttackAnimSpeed(@NotNull Entity $this$getAttackAnimSpeed, float baseSpeedValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getAttackAnimSpeed, (String)"<this>");
        Entity entity = $this$getAttackAnimSpeed;
        if (entity instanceof LivingEntity) {
            AttributeInstance attributeInstance = ((LivingEntity)entity).getAttribute(Attributes.ATTACK_SPEED);
            if (attributeInstance == null) {
                return 1.0f;
            }
            AttributeInstance sp = attributeInstance;
            return RangesKt.coerceAtLeast((float)(((float)sp.getValue() - baseSpeedValue) / (float)2 + 1.0f), (float)0.05f);
        }
        return 1.0f;
    }

    public static final void knockBackRelativeView(@NotNull LivingEntity $this$knockBackRelativeView, @NotNull Entity attacker, double strength) {
        Intrinsics.checkNotNullParameter((Object)$this$knockBackRelativeView, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        $this$knockBackRelativeView.knockback(strength, Math.sin((double)attacker.getYRot() * (Math.PI / 180)), -Math.cos((double)attacker.getYRot() * (Math.PI / 180)));
    }

    public static final void knockBackRelative(@NotNull LivingEntity $this$knockBackRelative, @NotNull Vec3 relative, double strength) {
        Intrinsics.checkNotNullParameter((Object)$this$knockBackRelative, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        $this$knockBackRelative.knockback(strength, relative.x - $this$knockBackRelative.getX(), relative.z - $this$knockBackRelative.getZ());
    }

    public static final void addRelativeMovement(@NotNull Entity $this$addRelativeMovement, @NotNull Vec3 relative, @NotNull Vec3 move) {
        Intrinsics.checkNotNullParameter((Object)$this$addRelativeMovement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        Vector2d r = new Vector2d(relative.x - $this$addRelativeMovement.getX(), relative.z - $this$addRelativeMovement.getZ());
        double angle = Math.atan2(r.y, -r.x) + (double)1.5707964f;
        Vec3 result = move.yRot((float)angle);
        $this$addRelativeMovement.addDeltaMovement(result);
    }

    @NotNull
    public static final Input copy(@NotNull Input $this$copy) {
        Input input;
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Input $this$copy_u24lambda_u240 = input = new Input();
        boolean bl = false;
        $this$copy_u24lambda_u240.leftImpulse = $this$copy.leftImpulse;
        $this$copy_u24lambda_u240.forwardImpulse = $this$copy.forwardImpulse;
        $this$copy_u24lambda_u240.up = $this$copy.up;
        $this$copy_u24lambda_u240.down = $this$copy.down;
        $this$copy_u24lambda_u240.left = $this$copy.left;
        $this$copy_u24lambda_u240.right = $this$copy.right;
        $this$copy_u24lambda_u240.jumping = $this$copy.jumping;
        $this$copy_u24lambda_u240.shiftKeyDown = $this$copy.shiftKeyDown;
        return input;
    }

    public static final boolean isAboveGround(@NotNull Entity $this$isAboveGround, double minDistance) {
        Intrinsics.checkNotNullParameter((Object)$this$isAboveGround, (String)"<this>");
        Iterable iterable = $this$isAboveGround.level().getBlockCollisions($this$isAboveGround, $this$isAboveGround.getBoundingBox().move(0.0, -minDistance, 0.0));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getBlockCollisions(...)");
        return CollectionsKt.toList((Iterable)iterable).isEmpty();
    }
}

