/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.entity.attack;

import cn.solarmoon.spark_core.entity.attack.AttackContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH&J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcn/solarmoon/spark_core/entity/attack/AttackSystem;", "", "context", "Lcn/solarmoon/spark_core/entity/attack/AttackContext;", "<init>", "(Lcn/solarmoon/spark_core/entity/attack/AttackContext;)V", "getContext", "()Lcn/solarmoon/spark_core/entity/attack/AttackContext;", "ignoreInvulnerableTime", "", "getIgnoreInvulnerableTime", "()Z", "onAttack", "target", "Lnet/minecraft/world/entity/Entity;", "attack", "SparkCore-1.21.1-neoforge"})
public abstract class AttackSystem {
    @NotNull
    private final AttackContext context;
    private final boolean ignoreInvulnerableTime;

    public AttackSystem(@NotNull AttackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.ignoreInvulnerableTime = true;
    }

    @NotNull
    public final AttackContext getContext() {
        return this.context;
    }

    public final boolean getIgnoreInvulnerableTime() {
        return this.ignoreInvulnerableTime;
    }

    public abstract boolean onAttack(@NotNull Entity var1);

    public final boolean attack(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target.level().isClientSide) {
            return false;
        }
        if (this.context.hasAttacked(target)) {
            return false;
        }
        if (this.onAttack(target)) {
            this.context.recordAttack(target);
            if (this.ignoreInvulnerableTime) {
                target.invulnerableTime = 0;
            }
            return true;
        }
        return false;
    }
}

