/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.entity.goal;

import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcn/solarmoon/spark_core/entity/goal/DirectAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "mob", "Lnet/minecraft/world/entity/Mob;", "speedModifier", "", "stopDistance", "<init>", "(Lnet/minecraft/world/entity/Mob;DD)V", "tick", "", "requiresUpdateEveryTick", "", "start", "canUse", "SparkCore-1.21.1-neoforge"})
public final class DirectAttackGoal
extends Goal {
    @NotNull
    private final Mob mob;
    private final double speedModifier;
    private final double stopDistance;

    public DirectAttackGoal(@NotNull Mob mob, double speedModifier, double stopDistance) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    public void tick() {
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        if ((double)this.mob.distanceTo((Entity)target) > this.stopDistance) {
            this.mob.getNavigation().moveTo((Entity)target, this.speedModifier);
        } else {
            this.mob.getNavigation().stop();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUse() {
        if (this.mob.getTarget() == null) return false;
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity == null) return false;
        if (!livingEntity.isAlive()) return false;
        return true;
    }
}

