/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.entity.pathfinding;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ.\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013J \u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0015J\u0016\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0015J\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0015R\u0014\u0010\u0018\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcn/solarmoon/spark_core/entity/pathfinding/NaturalNavigateGround;", "Lnet/minecraft/world/entity/ai/navigation/GroundPathNavigation;", "mob", "Lnet/minecraft/world/entity/Mob;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/level/Level;)V", "followThePath", "", "isAt", "", "path", "Lnet/minecraft/world/level/pathfinder/Path;", "threshold", "", "atElevationChange", "tryShortcut", "entityPos", "Lnet/minecraft/world/phys/Vec3;", "pathLength", "", "base", "max", "EPSILON", "getEPSILON", "()F", "sweep", "vec", "leadEdgeToInt", "coord", "step", "trailEdgeToInt", "element", "v", "i", "SparkCore-1.21.1-neoforge"})
public final class NaturalNavigateGround
extends GroundPathNavigation {
    private final float EPSILON;

    public NaturalNavigateGround(@NotNull Mob mob, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(mob, level);
        this.EPSILON = 1.0E-8f;
    }

    protected void followThePath() {
        Path path = this.path;
        if (path == null) {
            return;
        }
        Path path2 = path;
        Vec3 entityPos = this.getTempMobPos();
        int pathLength = path2.getNodeCount();
        int n = path2.getNodeCount();
        for (int i = path2.getNextNodeIndex(); i < n; ++i) {
            if ((double)path2.getNode((int)i).y == Math.floor(entityPos.y)) continue;
            pathLength = i;
            break;
        }
        Vec3 base2 = entityPos.add((double)(-this.mob.getBbWidth()) * 0.5, 0.0, (double)(-this.mob.getBbWidth()) * 0.5);
        Vec3 max = base2.add((double)this.mob.getBbWidth(), (double)this.mob.getBbHeight(), (double)this.mob.getBbWidth());
        Vec3 vec3 = new Vec3(this.mob.getX(), this.mob.getY(), this.mob.getZ());
        Intrinsics.checkNotNull((Object)base2);
        Intrinsics.checkNotNull((Object)max);
        if (this.tryShortcut(path2, vec3, pathLength, base2, max) && (this.isAt(path2, 0.5f) || this.atElevationChange(path2) && this.isAt(path2, this.mob.getBbWidth() * 0.5f))) {
            path2.setNextNodeIndex(path2.getNextNodeIndex() + 1);
        }
        this.doStuckDetection(entityPos);
    }

    public final boolean isAt(@NotNull Path path, float threshold) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Vec3 pathPos = path.getNextEntityPos((Entity)this.mob);
        return Mth.abs((float)((float)(this.mob.getX() - pathPos.x))) < threshold && Mth.abs((float)((float)(this.mob.getZ() - pathPos.z))) < threshold && Math.abs(this.mob.getY() - pathPos.y) < 1.0;
    }

    public final boolean atElevationChange(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int curr = path.getNextNodeIndex();
        int end = RangesKt.coerceAtMost((int)path.getNodeCount(), (int)(curr + Mth.ceil((float)(this.mob.getBbWidth() * 0.5f)) + 1));
        int currY = path.getNode((int)curr).y;
        for (int i = curr + 1; i < end; ++i) {
            if (path.getNode((int)i).y == currY) continue;
            return true;
        }
        return false;
    }

    public final boolean tryShortcut(@NotNull Path path, @NotNull Vec3 entityPos, int pathLength, @NotNull Vec3 base2, @NotNull Vec3 max) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entityPos, (String)"entityPos");
        Intrinsics.checkNotNullParameter((Object)base2, (String)"base");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        int i = pathLength - 1;
        int n = path.getNextNodeIndex() + 1;
        if (n <= i) {
            while (true) {
                Vec3 vec = path.getEntityPosAtNode((Entity)this.mob, i).subtract(entityPos);
                Intrinsics.checkNotNull((Object)vec);
                if (this.sweep(vec, base2, max)) {
                    path.setNextNodeIndex(i);
                    return false;
                }
                if (i == n) break;
                --i;
            }
        }
        return true;
    }

    public final float getEPSILON() {
        return this.EPSILON;
    }

    private final boolean sweep(Vec3 vec, Vec3 base2, Vec3 max) {
        float maxT = (float)vec.length();
        if (maxT >= this.EPSILON) {
            float[] tr = new float[3];
            int[] ldi = new int[3];
            int[] tri = new int[3];
            int[] step = new int[3];
            float[] tDelta = new float[3];
            float[] tNext = new float[3];
            float[] normed = new float[3];
            for (int i = 0; i < 3; ++i) {
                float value = this.element(vec, i);
                boolean dir = value >= 0.0f;
                step[i] = dir ? 1 : -1;
                float lead = this.element(dir ? max : base2, i);
                tr[i] = this.element(dir ? base2 : max, i);
                ldi[i] = this.leadEdgeToInt(lead, step[i]);
                tri[i] = this.trailEdgeToInt(tr[i], step[i]);
                normed[i] = value / maxT;
                tDelta[i] = Mth.abs((float)(maxT / value));
                float dist = dir ? (float)(ldi[i] + 1) - lead : lead - (float)ldi[i];
                tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
            }
        }
        return true;
    }

    public final int leadEdgeToInt(float coord, int step) {
        return Mth.floor((float)(coord - (float)step * this.EPSILON));
    }

    public final int trailEdgeToInt(float coord, int step) {
        return Mth.floor((float)(coord + (float)step * this.EPSILON));
    }

    public final float element(@NotNull Vec3 v, int i) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return switch (i) {
            case 0 -> (float)v.x;
            case 1 -> (float)v.y;
            case 2 -> (float)v.z;
            default -> 0.0f;
        };
    }
}

