/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.fluid;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcn/solarmoon/spark_core/fluid/BaseFluid;", "Lnet/neoforged/neoforge/fluids/BaseFlowingFluid;", "properties", "Lnet/neoforged/neoforge/fluids/BaseFlowingFluid$Properties;", "<init>", "(Lnet/neoforged/neoforge/fluids/BaseFlowingFluid$Properties;)V", "underFluidParticle", "Lnet/minecraft/core/particles/ParticleOptions;", "getUnderFluidParticle", "()Lnet/minecraft/core/particles/ParticleOptions;", "animateTick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/material/FluidState;", "randomSource", "Lnet/minecraft/util/RandomSource;", "FluidBlock", "Bucket", "Flowing", "Source", "SparkCore-1.21.1-neoforge"})
public abstract class BaseFluid
extends BaseFlowingFluid {
    public BaseFluid(@NotNull BaseFlowingFluid.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public final ParticleOptions getUnderFluidParticle() {
        SimpleParticleType simpleParticleType = ParticleTypes.UNDERWATER;
        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"UNDERWATER");
        return (ParticleOptions)simpleParticleType;
    }

    protected void animateTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull FluidState state2, @NotNull RandomSource randomSource) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)randomSource, (String)"randomSource");
        if (!state2.isSource() && !((Boolean)state2.getValue((Property)BaseFlowingFluid.FALLING)).booleanValue()) {
            if (randomSource.nextInt(64) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, randomSource.nextFloat() * 0.25f + 0.75f, randomSource.nextFloat() + 0.5f, false);
            }
        } else if (randomSource.nextInt(10) == 0) {
            level.addParticle(this.getUnderFluidParticle(), (double)pos.getX() + randomSource.nextDouble(), (double)pos.getY() + randomSource.nextDouble(), (double)pos.getZ() + randomSource.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcn/solarmoon/spark_core/fluid/BaseFluid$Bucket;", "Lnet/minecraft/world/item/BucketItem;", "content", "Lnet/minecraft/world/level/material/Fluid;", "<init>", "(Lnet/minecraft/world/level/material/Fluid;)V", "SparkCore-1.21.1-neoforge"})
    public static class Bucket
    extends BucketItem {
        public Bucket(@NotNull Fluid content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            super(content, new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcn/solarmoon/spark_core/fluid/BaseFluid$Flowing;", "Lnet/neoforged/neoforge/fluids/BaseFlowingFluid$Flowing;", "properties", "Lnet/neoforged/neoforge/fluids/BaseFlowingFluid$Properties;", "<init>", "(Lnet/neoforged/neoforge/fluids/BaseFlowingFluid$Properties;)V", "SparkCore-1.21.1-neoforge"})
    public static class Flowing
    extends BaseFlowingFluid.Flowing {
        public Flowing(@NotNull BaseFlowingFluid.Properties properties) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            super(properties);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcn/solarmoon/spark_core/fluid/BaseFluid$FluidBlock;", "Lnet/minecraft/world/level/block/LiquidBlock;", "flowingFluid", "Lnet/minecraft/world/level/material/FlowingFluid;", "<init>", "(Lnet/minecraft/world/level/material/FlowingFluid;)V", "SparkCore-1.21.1-neoforge"})
    public static class FluidBlock
    extends LiquidBlock {
        public FluidBlock(@NotNull FlowingFluid flowingFluid) {
            Intrinsics.checkNotNullParameter((Object)flowingFluid, (String)"flowingFluid");
            super(flowingFluid, BlockBehaviour.Properties.of().replaceable().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcn/solarmoon/spark_core/fluid/BaseFluid$Source;", "Lnet/neoforged/neoforge/fluids/BaseFlowingFluid$Source;", "properties", "Lnet/neoforged/neoforge/fluids/BaseFlowingFluid$Properties;", "<init>", "(Lnet/neoforged/neoforge/fluids/BaseFlowingFluid$Properties;)V", "SparkCore-1.21.1-neoforge"})
    public static class Source
    extends BaseFlowingFluid.Source {
        public Source(@NotNull BaseFlowingFluid.Properties properties) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            super(properties);
        }
    }
}

