/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.gas;

import cn.solarmoon.spark_core.SparkCore;
import cn.solarmoon.spark_core.gas.Ability;
import cn.solarmoon.spark_core.gas.AbilityHandle;
import cn.solarmoon.spark_core.gas.AbilitySystemComponent;
import cn.solarmoon.spark_core.gas.AbilityTask;
import cn.solarmoon.spark_core.gas.AbilityType;
import cn.solarmoon.spark_core.gas.AbilityTypeManager;
import cn.solarmoon.spark_core.gas.ActivationContext;
import cn.solarmoon.spark_core.gas.GameplayTagContainer;
import cn.solarmoon.spark_core.gas.InstancingPolicy;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 )*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001)B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u001fJ\u0016\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u001cJ\u0006\u0010'\u001a\u00020\u001fJ\u0006\u0010(\u001a\u00020\u001fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001d\u00a8\u0006*"}, d2={"Lcn/solarmoon/spark_core/gas/AbilitySpec;", "A", "Lcn/solarmoon/spark_core/gas/Ability;", "", "abilityType", "Lcn/solarmoon/spark_core/gas/AbilityType;", "<init>", "(Lcn/solarmoon/spark_core/gas/AbilityType;)V", "getAbilityType", "()Lcn/solarmoon/spark_core/gas/AbilityType;", "value", "Lcn/solarmoon/spark_core/gas/AbilitySystemComponent;", "asc", "getAsc", "()Lcn/solarmoon/spark_core/gas/AbilitySystemComponent;", "Lcn/solarmoon/spark_core/gas/AbilityHandle;", "handle", "getHandle", "()Lcn/solarmoon/spark_core/gas/AbilityHandle;", "dynamicTags", "Lcn/solarmoon/spark_core/gas/GameplayTagContainer;", "getDynamicTags", "()Lcn/solarmoon/spark_core/gas/GameplayTagContainer;", "activeAbilities", "", "getActiveAbilities", "()Ljava/util/List;", "isActive", "", "()Z", "initialize", "", "tryActivate", "context", "Lcn/solarmoon/spark_core/gas/ActivationContext;", "tick", "endAbility", "ability", "wasCancelled", "cancelAll", "endAll", "Companion", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nAbilitySpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbilitySpec.kt\ncn/solarmoon/spark_core/gas/AbilitySpec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1869#2,2:86\n1869#2,2:88\n1869#2,2:90\n1869#2,2:92\n*S KotlinDebug\n*F\n+ 1 AbilitySpec.kt\ncn/solarmoon/spark_core/gas/AbilitySpec\n*L\n56#1:86,2\n63#1:88,2\n69#1:90,2\n73#1:92,2\n*E\n"})
public final class AbilitySpec<A extends Ability> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbilityType<A> abilityType;
    private AbilitySystemComponent asc;
    @NotNull
    private AbilityHandle handle;
    @NotNull
    private final GameplayTagContainer dynamicTags;
    @NotNull
    private final List<Ability> activeAbilities;
    private static final StreamCodec<ByteBuf, AbilitySpec<? extends Ability>> STREAM_CODEC = AbilityType.Companion.getSTREAM_CODEC().map(arg_0 -> AbilitySpec.STREAM_CODEC$lambda$6(AbilitySpec::STREAM_CODEC$lambda$5, arg_0), arg_0 -> AbilitySpec.STREAM_CODEC$lambda$8(AbilitySpec::STREAM_CODEC$lambda$7, arg_0));

    public AbilitySpec(@NotNull AbilityType<A> abilityType) {
        Intrinsics.checkNotNullParameter(abilityType, (String)"abilityType");
        this.abilityType = abilityType;
        this.handle = new AbilityHandle(-1);
        this.dynamicTags = new GameplayTagContainer(null, 1, null);
        this.activeAbilities = new ArrayList();
    }

    @NotNull
    public final AbilityType<A> getAbilityType() {
        return this.abilityType;
    }

    @NotNull
    public final AbilitySystemComponent getAsc() {
        AbilitySystemComponent abilitySystemComponent = this.asc;
        if (abilitySystemComponent != null) {
            return abilitySystemComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"asc");
        return null;
    }

    @NotNull
    public final AbilityHandle getHandle() {
        return this.handle;
    }

    @NotNull
    public final GameplayTagContainer getDynamicTags() {
        return this.dynamicTags;
    }

    @NotNull
    public final List<Ability> getActiveAbilities() {
        return this.activeAbilities;
    }

    public final boolean isActive() {
        return !((Collection)this.activeAbilities).isEmpty();
    }

    public final void initialize(@NotNull AbilitySystemComponent asc, @NotNull AbilityHandle handle) {
        Intrinsics.checkNotNullParameter((Object)asc, (String)"asc");
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        this.asc = asc;
        this.handle = handle;
    }

    public final boolean tryActivate(@NotNull ActivationContext context) {
        Object ability;
        boolean result;
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.asc == null) {
            SparkCore.LOGGER.info("\u6280\u80fd\u5bb9\u5668(" + AbilityTypeManager.INSTANCE.getKey(this.abilityType) + ")\u8fd8\u672a\u6388\u4e88\u5230\u6280\u80fd\u6301\u6709\u8005\u4e2d\uff0c\u65e0\u6cd5\u6fc0\u6d3b\u6280\u80fd");
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.abilityType.getInstancingPolicy().ordinal()]) {
            case 1: {
                object = (Ability)CollectionsKt.firstOrNull(this.activeAbilities);
                if (object != null) break;
                object = this.abilityType.create();
                break;
            }
            case 2: {
                object = this.abilityType.create();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (bl = (result = ((Ability)(ability = object)).canActivate(this, context))) {
            ((Collection)this.activeAbilities).add(ability);
            ((Ability)ability).activate(this, context);
        } else if (bl) {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    public final void tick() {
        Iterable $this$forEach$iv = this.activeAbilities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Ability it = (Ability)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getTasks();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AbilityTask it2 = (AbilityTask)element$iv2;
                boolean bl2 = false;
                it2.tick();
            }
        }
    }

    public final void endAbility(@NotNull Ability ability, boolean wasCancelled) {
        Intrinsics.checkNotNullParameter((Object)ability, (String)"ability");
        if (!this.activeAbilities.contains(ability)) {
            return;
        }
        ability.end(this, wasCancelled);
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)ability.getTasks());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbilityTask it = (AbilityTask)element$iv;
            boolean bl = false;
            it.end(true);
        }
        ability.getTasks().clear();
        this.activeAbilities.remove(ability);
    }

    public final void cancelAll() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.activeAbilities);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Ability it = (Ability)element$iv;
            boolean bl = false;
            this.endAbility(it, true);
        }
    }

    public final void endAll() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.activeAbilities);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Ability it = (Ability)element$iv;
            boolean bl = false;
            this.endAbility(it, false);
        }
    }

    private static final AbilitySpec STREAM_CODEC$lambda$5(AbilityType it) {
        Intrinsics.checkNotNull((Object)it);
        return new AbilitySpec(it);
    }

    private static final AbilitySpec STREAM_CODEC$lambda$6(Function1 $tmp0, Object p0) {
        return (AbilitySpec)$tmp0.invoke(p0);
    }

    private static final AbilityType STREAM_CODEC$lambda$7(AbilitySpec it) {
        return it.abilityType;
    }

    private static final AbilityType STREAM_CODEC$lambda$8(Function1 $tmp0, Object p0) {
        return (AbilityType)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Rs\u0010\u0004\u001ab\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\t \u0007*\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\b0\b \u0007*0\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\t \u0007*\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\b0\b\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcn/solarmoon/spark_core/gas/AbilitySpec$Companion;", "", "<init>", "()V", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "Lcn/solarmoon/spark_core/gas/AbilitySpec;", "Lcn/solarmoon/spark_core/gas/Ability;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/codec/StreamCodec;", "SparkCore-1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public final StreamCodec<ByteBuf, AbilitySpec<? extends Ability>> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InstancingPolicy.values().length];
            try {
                nArray[InstancingPolicy.INSTANCED_PER_ACTOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstancingPolicy.INSTANCED_PER_EXECUTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

