/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.gas;

import cn.solarmoon.spark_core.gas.AbilityEvent;
import cn.solarmoon.spark_core.gas.AbilityHandle;
import cn.solarmoon.spark_core.gas.AbilityHost;
import cn.solarmoon.spark_core.gas.AbilitySpec;
import cn.solarmoon.spark_core.gas.ActivationContext;
import cn.solarmoon.spark_core.gas.GameplayTag;
import cn.solarmoon.spark_core.gas.sync.EndAbilityLocalPayload;
import cn.solarmoon.spark_core.gas.sync.TryActivateAbilityLocalPayload;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0018\u001a\u00020\u00172\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0011J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0010J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0010J\u0006\u0010#\u001a\u00020\u0017J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0010J.\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00112\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015J\u001a\u0010(\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0011J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0016J\u0006\u0010+\u001a\u00020\u0017J\u0014\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u0010J\u0014\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u00104\u001a\u000205J\u0012\u00106\u001a\u00020\u00172\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0011J\u0016\u00107\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u00108\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0012\u001a0\u0012\u0004\u0012\u00020\u0013\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u00140\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R!\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110-8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/\u00a8\u00069"}, d2={"Lcn/solarmoon/spark_core/gas/AbilitySystemComponent;", "", "owner", "Lcn/solarmoon/spark_core/gas/AbilityHost;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lcn/solarmoon/spark_core/gas/AbilityHost;Lnet/minecraft/world/level/Level;)V", "getOwner", "()Lcn/solarmoon/spark_core/gas/AbilityHost;", "getLevel", "()Lnet/minecraft/world/level/Level;", "nextHandleId", "", "abilitySpecs", "", "Lcn/solarmoon/spark_core/gas/AbilityHandle;", "Lcn/solarmoon/spark_core/gas/AbilitySpec;", "listeners", "Lcn/solarmoon/spark_core/gas/GameplayTag;", "", "Lkotlin/Function1;", "Lcn/solarmoon/spark_core/gas/AbilityEvent;", "", "giveAbility", "spec", "clearAbility", "handle", "tryActivateAbility", "", "context", "Lcn/solarmoon/spark_core/gas/ActivationContext;", "tryActivateAbilityLocal", "cancelAbility", "endAbility", "endAllAbilities", "endAbilityLocal", "registerListener", "tag", "callback", "unregisterListener", "handleGameplayEvent", "event", "tick", "allAbilitySpecs", "", "getAllAbilitySpecs", "()Ljava/util/Map;", "activeAbilitySpecs", "getActiveAbilitySpecs", "findSpecFromHandle", "findSpecFromLocation", "location", "Lnet/minecraft/resources/ResourceLocation;", "onRepGiveAbility", "onRepTryActivateAbility", "onRepEndAllAbilities", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nAbilitySystemComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbilitySystemComponent.kt\ncn/solarmoon/spark_core/gas/AbilitySystemComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,150:1\n1869#2,2:151\n1869#2,2:154\n1869#2,2:157\n295#2,2:166\n1869#2,2:168\n216#3:153\n217#3:156\n538#4:159\n523#4,6:160\n*S KotlinDebug\n*F\n+ 1 AbilitySystemComponent.kt\ncn/solarmoon/spark_core/gas/AbilitySystemComponent\n*L\n90#1:151,2\n114#1:154,2\n119#1:157,2\n132#1:166,2\n147#1:168,2\n113#1:153\n113#1:156\n125#1:159\n125#1:160,6\n*E\n"})
public final class AbilitySystemComponent {
    @NotNull
    private final AbilityHost owner;
    @NotNull
    private final Level level;
    private int nextHandleId;
    @NotNull
    private final Map<AbilityHandle, AbilitySpec<?>> abilitySpecs;
    @NotNull
    private final Map<GameplayTag, Map<AbilitySpec<?>, List<Function1<AbilityEvent, Unit>>>> listeners;

    public AbilitySystemComponent(@NotNull AbilityHost owner, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.owner = owner;
        this.level = level;
        this.nextHandleId = 1;
        this.abilitySpecs = new LinkedHashMap();
        this.listeners = new LinkedHashMap();
    }

    @NotNull
    public final AbilityHost getOwner() {
        return this.owner;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public final void giveAbility(@NotNull AbilitySpec<?> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        int n = this.nextHandleId;
        this.nextHandleId = n + 1;
        AbilityHandle handle = new AbilityHandle(n);
        spec.initialize(this, handle);
        if (!this.level.isClientSide) {
            this.abilitySpecs.put(handle, spec);
        }
    }

    public final void clearAbility(@NotNull AbilityHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        if (!this.level.isClientSide) {
            AbilitySpec<?> abilitySpec = this.abilitySpecs.remove(handle);
            if (abilitySpec != null) {
                abilitySpec.endAll();
            }
            this.owner.syncClearAbility(handle);
        }
    }

    public final boolean tryActivateAbility(@NotNull AbilityHandle handle, @NotNull ActivationContext context) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.level.isClientSide) {
            AbilitySpec<?> abilitySpec = this.abilitySpecs.get(handle);
            boolean bl = abilitySpec != null ? abilitySpec.tryActivate(context) : false;
            if (bl) {
                this.owner.syncTryActivateAbility(handle, context);
                return true;
            }
        }
        return false;
    }

    public final boolean tryActivateAbilityLocal(@NotNull AbilityHandle handle, @NotNull ActivationContext context) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (FMLEnvironment.dist.isClient()) {
            AbilitySpec<?> abilitySpec = this.abilitySpecs.get(handle);
            boolean bl = abilitySpec != null ? abilitySpec.tryActivate(context) : false;
            if (bl) {
                PacketDistributor.sendToServer((CustomPacketPayload)new TryActivateAbilityLocalPayload(handle, context), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return false;
    }

    public final void cancelAbility(@NotNull AbilityHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        if (!this.level.isClientSide) {
            AbilitySpec<?> abilitySpec = this.abilitySpecs.get(handle);
            if (abilitySpec != null) {
                abilitySpec.cancelAll();
            }
            this.owner.syncCancelAbility(handle);
        }
    }

    public final void endAbility(@NotNull AbilityHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        if (!this.level.isClientSide) {
            AbilitySpec<?> abilitySpec = this.abilitySpecs.get(handle);
            if (abilitySpec != null) {
                abilitySpec.endAll();
            }
            this.owner.syncEndAbility(handle);
        }
    }

    public final void endAllAbilities() {
        if (!this.level.isClientSide) {
            Iterable $this$forEach$iv = this.abilitySpecs.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbilitySpec it = (AbilitySpec)element$iv;
                boolean bl = false;
                it.endAll();
            }
            this.owner.syncEndAllAbilities();
        }
    }

    public final void endAbilityLocal(@NotNull AbilityHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        if (FMLEnvironment.dist.isClient()) {
            AbilitySpec<?> abilitySpec = this.abilitySpecs.get(handle);
            if (abilitySpec != null) {
                abilitySpec.endAll();
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new EndAbilityLocalPayload(handle), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public final void registerListener(@NotNull GameplayTag tag, @NotNull AbilitySpec<?> spec, @NotNull Function1<? super AbilityEvent, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.listeners.computeIfAbsent(tag, arg_0 -> AbilitySystemComponent.registerListener$lambda$2(AbilitySystemComponent::registerListener$lambda$1, arg_0)).computeIfAbsent(spec, arg_0 -> AbilitySystemComponent.registerListener$lambda$4(AbilitySystemComponent::registerListener$lambda$3, arg_0)).add(callback);
    }

    public final void unregisterListener(@NotNull GameplayTag tag, @NotNull AbilitySpec<?> spec) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter(spec, (String)"spec");
            Map<AbilitySpec<?>, List<Function1<AbilityEvent, Unit>>> map = this.listeners.get(tag);
            if (map == null) break block0;
            map.remove(spec);
        }
    }

    public final void handleGameplayEvent(@NotNull AbilityEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Map<AbilitySpec<?>, List<Function1<AbilityEvent, Unit>>> map = this.listeners.get(event.getTag());
            if (map == null) break block2;
            Map<AbilitySpec<?>, List<Function1<AbilityEvent, Unit>>> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<AbilitySpec<?>, List<Function1<AbilityEvent, Unit>>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<AbilitySpec<?>, List<Function1<AbilityEvent, Unit>>> element$iv;
                Map.Entry<AbilitySpec<?>, List<Function1<AbilityEvent, Unit>>> entry = element$iv = iterator.next();
                boolean bl = false;
                AbilitySpec<?> spec = entry.getKey();
                List<Function1<AbilityEvent, Unit>> callbacks = entry.getValue();
                Iterable $this$forEach$iv2 = callbacks;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Function1 it = (Function1)element$iv2;
                    boolean bl2 = false;
                    it.invoke((Object)event);
                }
            }
        }
    }

    public final void tick() {
        Iterable $this$forEach$iv = this.abilitySpecs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbilitySpec it = (AbilitySpec)element$iv;
            boolean bl = false;
            it.tick();
        }
    }

    @NotNull
    public final Map<AbilityHandle, AbilitySpec<?>> getAllAbilitySpecs() {
        return MapsKt.toMap(this.abilitySpecs);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<AbilityHandle, AbilitySpec<?>> getActiveAbilitySpecs() {
        void $this$filterTo$iv$iv;
        Map<AbilityHandle, AbilitySpec<?>> $this$filter$iv = this.abilitySpecs;
        boolean $i$f$filter = false;
        Map<AbilityHandle, AbilitySpec<?>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((AbilitySpec)it.getValue()).isActive()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    @Nullable
    public final AbilitySpec<?> findSpecFromHandle(@NotNull AbilityHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        return this.abilitySpecs.get(handle);
    }

    @Nullable
    public final AbilitySpec<?> findSpecFromLocation(@NotNull ResourceLocation location) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Iterable $this$firstOrNull$iv = this.abilitySpecs.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AbilitySpec it = (AbilitySpec)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAbilityType().getRegistryKey(), (Object)location)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void onRepGiveAbility(@NotNull AbilitySpec<?> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        this.abilitySpecs.put(spec.getHandle(), spec);
    }

    public final void onRepTryActivateAbility(@NotNull AbilityHandle handle, @NotNull ActivationContext context) {
        block0: {
            AbilitySpec<?> abilitySpec;
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AbilitySpec<?> abilitySpec2 = this.abilitySpecs.get(handle);
            if (abilitySpec2 == null) break block0;
            AbilitySpec<?> $this$onRepTryActivateAbility_u24lambda_u2410 = abilitySpec = abilitySpec2;
            boolean bl = false;
            $this$onRepTryActivateAbility_u24lambda_u2410.tryActivate(context);
        }
    }

    public final void onRepEndAllAbilities() {
        Iterable $this$forEach$iv = this.abilitySpecs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbilitySpec it = (AbilitySpec)element$iv;
            boolean bl = false;
            it.endAll();
        }
    }

    private static final Map registerListener$lambda$1(GameplayTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final Map registerListener$lambda$2(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final List registerListener$lambda$3(AbilitySpec it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List registerListener$lambda$4(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

