/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.gas;

import cn.solarmoon.spark_core.gas.AbilityType;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0017H&J\"\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000f2\b\b\u0002\u0010\u001b\u001a\u00020\u0005H\u0004J\u001d\u0010\u0019\u001a\n \u001c*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u0019\u001a\u00020\u0005H\u0004\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/solarmoon/spark_core/gas/AbilityTypeDataProvider;", "Lnet/minecraft/data/DataProvider;", "output", "Lnet/minecraft/data/PackOutput;", "packName", "", "modId", "<init>", "(Lnet/minecraft/data/PackOutput;Ljava/lang/String;Ljava/lang/String;)V", "getPackName", "()Ljava/lang/String;", "getModId", "abilityTypes", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcn/solarmoon/spark_core/gas/AbilityType$Serializer;", "prefixes", "run", "Ljava/util/concurrent/CompletableFuture;", "c", "Lnet/minecraft/data/CachedOutput;", "getName", "buildAbilities", "", "add", "id", "abilityType", "prefix", "kotlin.jvm.PlatformType", "(Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;", "SparkCore-1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nAbilityTypeDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbilityTypeDataProvider.kt\ncn/solarmoon/spark_core/gas/AbilityTypeDataProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,50:1\n37#2:51\n36#2,3:52\n*S KotlinDebug\n*F\n+ 1 AbilityTypeDataProvider.kt\ncn/solarmoon/spark_core/gas/AbilityTypeDataProvider\n*L\n36#1:51\n36#1:52,3\n*E\n"})
public abstract class AbilityTypeDataProvider
implements DataProvider {
    @NotNull
    private final PackOutput output;
    @NotNull
    private final String packName;
    @NotNull
    private final String modId;
    @NotNull
    private final Map<ResourceLocation, AbilityType.Serializer> abilityTypes;
    @NotNull
    private final Map<ResourceLocation, String> prefixes;

    public AbilityTypeDataProvider(@NotNull PackOutput output, @NotNull String packName, @NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)packName, (String)"packName");
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.output = output;
        this.packName = packName;
        this.modId = modId;
        this.abilityTypes = new LinkedHashMap();
        this.prefixes = new LinkedHashMap();
    }

    @NotNull
    public final String getPackName() {
        return this.packName;
    }

    @NotNull
    public final String getModId() {
        return this.modId;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.buildAbilities();
        List futures = new ArrayList();
        for (Map.Entry<ResourceLocation, AbilityType.Serializer> completableFutureArray2 : this.abilityTypes.entrySet()) {
            ResourceLocation id = completableFutureArray2.getKey();
            AbilityType.Serializer graph = completableFutureArray2.getValue();
            String prefix = this.prefixes.getOrDefault(id, "");
            Path path = this.output.getOutputFolder().resolve("spark_modules/" + this.packName + "/ability/" + this.modId + "/" + prefix + id.getPath() + ".json");
            JsonElement json = (JsonElement)AbilityType.Serializer.Companion.getCODEC().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)graph).getOrThrow();
            ((Collection)futures).add(DataProvider.saveStable((CachedOutput)c, (JsonElement)json, (Path)path));
        }
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"allOf(...)");
        return completableFuture;
    }

    @NotNull
    public String getName() {
        return "Spark Core Ability";
    }

    public abstract void buildAbilities();

    protected final void add(@NotNull ResourceLocation id, @NotNull AbilityType.Serializer abilityType, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)abilityType, (String)"abilityType");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.abilityTypes.put(id, abilityType);
        this.prefixes.put(id, prefix);
    }

    public static /* synthetic */ void add$default(AbilityTypeDataProvider abilityTypeDataProvider, ResourceLocation resourceLocation, AbilityType.Serializer serializer, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 4) != 0) {
            string = "";
        }
        abilityTypeDataProvider.add(resourceLocation, serializer, string);
    }

    protected final ResourceLocation id(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id);
    }
}

