/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.ik.visualizer;

import cn.solarmoon.spark_core.physics.level.PhysicsLevel;
import cn.solarmoon.spark_core.visual_effect.VisualEffectRenderer;
import com.jme3.math.Vector3f;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J0\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\nH\u0002J0\u0010(\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\nH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcn/solarmoon/spark_core/ik/visualizer/IKDebugRenderer;", "Lcn/solarmoon/spark_core/visual_effect/VisualEffectRenderer;", "<init>", "()V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "COLOR_RAY", "Lcn/solarmoon/spark_core/ik/visualizer/IKDebugRenderer$ColorRGBA;", "COLOR_DESIRED", "COLOR_ACTUAL_GROUNDED", "COLOR_ACTUAL_AIR", "TARGET_BOX_SIZE", "", "tick", "", "physTick", "physLevel", "Lcn/solarmoon/spark_core/physics/level/PhysicsLevel;", "render", "mc", "Lnet/minecraft/client/Minecraft;", "cameraPos", "Lnet/minecraft/world/phys/Vec3;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "tickDelta", "drawLine", "matrix", "Lorg/joml/Matrix4f;", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "start", "Lcom/jme3/math/Vector3f;", "end", "color", "drawWireBox", "center", "size", "ColorRGBA", "SparkCore-1.21.1-neoforge"})
public final class IKDebugRenderer
extends VisualEffectRenderer {
    private boolean isEnabled;
    @NotNull
    private final ColorRGBA COLOR_RAY = new ColorRGBA(0.8f, 0.8f, 0.8f, 0.8f);
    @NotNull
    private final ColorRGBA COLOR_DESIRED = new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f);
    @NotNull
    private final ColorRGBA COLOR_ACTUAL_GROUNDED = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    @NotNull
    private final ColorRGBA COLOR_ACTUAL_AIR = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    private final float TARGET_BOX_SIZE;

    public IKDebugRenderer() {
        this.TARGET_BOX_SIZE = 0.05f;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Override
    public void tick() {
    }

    @Override
    public void physTick(@NotNull PhysicsLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
    }

    @Override
    public void render(@NotNull Minecraft mc, @NotNull Vec3 cameraPos, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        if (!this.isEnabled) {
            return;
        }
    }

    private final void drawLine(Matrix4f matrix, VertexConsumer buffer, Vector3f start2, Vector3f end, ColorRGBA color) {
        buffer.addVertex(matrix, start2.x, start2.y, start2.z).setColor(color.getR(), color.getG(), color.getB(), color.getA()).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, end.x, end.y, end.z).setColor(color.getR(), color.getG(), color.getB(), color.getA()).setNormal(0.0f, 1.0f, 0.0f);
    }

    private final void drawWireBox(Matrix4f matrix, VertexConsumer buffer, Vector3f center, float size, ColorRGBA color) {
        float halfSize = size;
        float minX = center.x - halfSize;
        float minY = center.y - halfSize;
        float minZ = center.z - halfSize;
        float maxX = center.x + halfSize;
        float maxY = center.y + halfSize;
        float maxZ = center.z + halfSize;
        Vector3f p0 = new Vector3f(minX, minY, minZ);
        Vector3f p1 = new Vector3f(maxX, minY, minZ);
        Vector3f p2 = new Vector3f(maxX, minY, maxZ);
        Vector3f p3 = new Vector3f(minX, minY, maxZ);
        Vector3f p4 = new Vector3f(minX, maxY, minZ);
        Vector3f p5 = new Vector3f(maxX, maxY, minZ);
        Vector3f p6 = new Vector3f(maxX, maxY, maxZ);
        Vector3f p7 = new Vector3f(minX, maxY, maxZ);
        this.drawLine(matrix, buffer, p0, p1, color);
        this.drawLine(matrix, buffer, p1, p2, color);
        this.drawLine(matrix, buffer, p2, p3, color);
        this.drawLine(matrix, buffer, p3, p0, color);
        this.drawLine(matrix, buffer, p4, p5, color);
        this.drawLine(matrix, buffer, p5, p6, color);
        this.drawLine(matrix, buffer, p6, p7, color);
        this.drawLine(matrix, buffer, p7, p4, color);
        this.drawLine(matrix, buffer, p0, p4, color);
        this.drawLine(matrix, buffer, p1, p5, color);
        this.drawLine(matrix, buffer, p2, p6, color);
        this.drawLine(matrix, buffer, p3, p7, color);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lcn/solarmoon/spark_core/ik/visualizer/IKDebugRenderer$ColorRGBA;", "", "r", "", "g", "b", "a", "<init>", "(FFFF)V", "getR", "()F", "getG", "getB", "getA", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "SparkCore-1.21.1-neoforge"})
    private static final class ColorRGBA {
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        public ColorRGBA(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public final float getR() {
            return this.r;
        }

        public final float getG() {
            return this.g;
        }

        public final float getB() {
            return this.b;
        }

        public final float getA() {
            return this.a;
        }

        public final float component1() {
            return this.r;
        }

        public final float component2() {
            return this.g;
        }

        public final float component3() {
            return this.b;
        }

        public final float component4() {
            return this.a;
        }

        @NotNull
        public final ColorRGBA copy(float r, float g, float b, float a) {
            return new ColorRGBA(r, g, b, a);
        }

        public static /* synthetic */ ColorRGBA copy$default(ColorRGBA colorRGBA, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 1) != 0) {
                f = colorRGBA.r;
            }
            if ((n & 2) != 0) {
                f2 = colorRGBA.g;
            }
            if ((n & 4) != 0) {
                f3 = colorRGBA.b;
            }
            if ((n & 8) != 0) {
                f4 = colorRGBA.a;
            }
            return colorRGBA.copy(f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            return "ColorRGBA(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.r);
            result = result * 31 + Float.hashCode(this.g);
            result = result * 31 + Float.hashCode(this.b);
            result = result * 31 + Float.hashCode(this.a);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorRGBA)) {
                return false;
            }
            ColorRGBA colorRGBA = (ColorRGBA)other;
            if (Float.compare(this.r, colorRGBA.r) != 0) {
                return false;
            }
            if (Float.compare(this.g, colorRGBA.g) != 0) {
                return false;
            }
            if (Float.compare(this.b, colorRGBA.b) != 0) {
                return false;
            }
            return Float.compare(this.a, colorRGBA.a) == 0;
        }
    }
}

