/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.js.molang;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.anim.AnimInstance;
import cn.solarmoon.spark_core.util.ParticleUtilKt;
import cn.solarmoon.spark_core.util.SparkMathKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.graalvm.polyglot.HostAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0007J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0007J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0007J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcn/solarmoon/spark_core/js/molang/QueryContext;", "", "anim", "Lcn/solarmoon/spark_core/animation/anim/AnimInstance;", "<init>", "(Lcn/solarmoon/spark_core/animation/anim/AnimInstance;)V", "getAnim", "()Lcn/solarmoon/spark_core/animation/anim/AnimInstance;", "animatable", "Lcn/solarmoon/spark_core/animation/IAnimatable;", "getAnimatable", "()Lcn/solarmoon/spark_core/animation/IAnimatable;", "level", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "anim_time", "", "position", "Lorg/joml/Vector3f;", "kotlin.jvm.PlatformType", "()Lorg/joml/Vector3f;", "playSound", "", "sound", "", "source", "volume", "pitch", "pos", "", "addParticle", "particle", "reader", "SparkCore-1.21.1-neoforge"})
public final class QueryContext {
    @NotNull
    private final AnimInstance anim;
    @HostAccess.Export
    @JvmField
    public final double anim_time;

    public QueryContext(@NotNull AnimInstance anim) {
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        this.anim = anim;
        this.anim_time = this.anim.getTime();
    }

    @NotNull
    public final AnimInstance getAnim() {
        return this.anim;
    }

    @NotNull
    public final IAnimatable<?> getAnimatable() {
        return this.anim.getHolder();
    }

    @Nullable
    public final Level getLevel() {
        return this.getAnimatable().getAnimLevel();
    }

    @HostAccess.Export
    public final Vector3f position() {
        return this.getAnimatable().getWorldPositionMatrix(Float.valueOf(1.0f)).transformPosition(new Vector3f());
    }

    @HostAccess.Export
    public final void playSound(@NotNull String sound, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Vector3f vector3f = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"position(...)");
        Vec3 p = SparkMathKt.toVec3(vector3f).add(0.0, 1.0, 0.0);
        double[] dArray = new double[]{p.x, p.y, p.z};
        double[] pos = dArray;
        this.playSound(pos, sound, source, 1.0, 1.0);
    }

    @HostAccess.Export
    public final void playSound(@NotNull String sound, @NotNull String source, double volume, double pitch) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Vector3f vector3f = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"position(...)");
        Vec3 p = SparkMathKt.toVec3(vector3f).add(0.0, 1.0, 0.0);
        double[] dArray = new double[]{p.x, p.y, p.z};
        double[] pos = dArray;
        this.playSound(pos, sound, source, volume, pitch);
    }

    @HostAccess.Export
    public final void playSound(@NotNull double[] pos, @NotNull String sound, @NotNull String source, double volume, double pitch) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Level level = this.getLevel();
            if (level == null) break block0;
            double d = pos[0];
            double d2 = pos[1];
            double d3 = pos[2];
            SoundEvent soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)sound));
            String string = source.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            level.playSound(null, d, d2, d3, soundEvent, SoundSource.valueOf((String)string), (float)volume, (float)pitch);
        }
    }

    @HostAccess.Export
    public final void addParticle(@NotNull String particle, @NotNull double[] pos) {
        Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.addParticle(particle, "", pos);
    }

    @HostAccess.Export
    public final void addParticle(@NotNull String particle, @NotNull String reader, @NotNull double[] pos) {
        block0: {
            Level level;
            Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Vec3 pos2 = SparkMathKt.toVec3(pos);
            Level level2 = this.getLevel();
            if (level2 == null) break block0;
            Level $this$addParticle_u24lambda_u240 = level = level2;
            boolean bl = false;
            RegistryAccess registryAccess = $this$addParticle_u24lambda_u240.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            $this$addParticle_u24lambda_u240.addParticle(ParticleUtilKt.createParticleByString(registryAccess, particle, reader), pos2.x, pos2.y, pos2.z, 0.0, 0.0, 0.0);
        }
    }
}

