/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation;

import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.vanilla.VanillaModelHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ElytraModel.class})
public class ElytraModelMixin<T extends LivingEntity> {
    @Shadow
    @Final
    private ModelPart leftWing;
    @Shadow
    @Final
    private ModelPart rightWing;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
    private void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        LivingEntityRenderer lr;
        EntityModel model;
        EntityRenderer renderer;
        IEntityAnimatable animatable;
        if (entity instanceof IEntityAnimatable && VanillaModelHelper.shouldSwitchToAnim(animatable = (IEntityAnimatable)entity) && (renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entity)) instanceof LivingEntityRenderer && (model = (lr = (LivingEntityRenderer)renderer).getModel()) instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            VanillaModelHelper.setRoot(this.leftWing, humanoidModel.body);
            VanillaModelHelper.setRoot(this.rightWing, humanoidModel.body);
        }
    }
}

