/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation;

import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.vanilla.ITransformModel;
import cn.solarmoon.spark_core.animation.vanilla.VanillaModelHelper;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin<T extends LivingEntity>
implements ITransformModel {
    @Shadow
    @Final
    public ModelPart leftLeg;
    @Shadow
    @Final
    public ModelPart rightLeg;
    @Shadow
    @Final
    public ModelPart head;
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart body;
    boolean transform = true;

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;Ljava/util/function/Function;)V"}, at={@At(value="RETURN")})
    private void init(ModelPart root, Function renderType, CallbackInfo ci) {
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;copyFrom(Lnet/minecraft/client/model/geom/ModelPart;)V", ordinal=0)})
    private void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        IEntityAnimatable animatable;
        if (entity instanceof IEntityAnimatable && VanillaModelHelper.shouldSwitchToAnim(animatable = (IEntityAnimatable)entity)) {
            this.setDefault();
            if (this.shouldTransform() && animatable.getAnimController().isPlayingAnim()) {
                float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
                VanillaModelHelper.setRoot(this.leftArm, this.body);
                VanillaModelHelper.setRoot(this.rightArm, this.body);
                VanillaModelHelper.setRoot(this.head, this.body);
                VanillaModelHelper.setPivot(animatable, "waist", this.body);
                VanillaModelHelper.applyTransform(animatable, "leftArm", this.leftArm, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "rightArm", this.rightArm, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "leftLeg", this.leftLeg, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "rightLeg", this.rightLeg, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "waist", this.body, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "head", this.head, partialTicks);
            } else {
                this.setShouldTransform(true);
            }
        }
    }

    private void setDefault() {
        this.leftLeg.setPos(1.9f, 12.0f, 0.0f);
        this.rightLeg.setPos(-1.9f, 12.0f, 0.0f);
        this.rightArm.setPos(-5.0f, 2.0f, 0.0f);
        this.leftArm.setPos(5.0f, 2.0f, 0.0f);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.body.setPos(0.0f, 0.0f, 0.0f);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.head.zRot = 0.0f;
        this.head.xScale = 1.0f;
        this.head.yScale = 1.0f;
        this.head.zScale = 1.0f;
        this.body.xScale = 1.0f;
        this.body.yScale = 1.0f;
        this.body.zScale = 1.0f;
        this.rightArm.xScale = 1.0f;
        this.rightArm.yScale = 1.0f;
        this.rightArm.zScale = 1.0f;
        this.leftArm.xScale = 1.0f;
        this.leftArm.yScale = 1.0f;
        this.leftArm.zScale = 1.0f;
        this.rightLeg.xScale = 1.0f;
        this.rightLeg.yScale = 1.0f;
        this.rightLeg.zScale = 1.0f;
        this.leftLeg.xScale = 1.0f;
        this.leftLeg.yScale = 1.0f;
        this.leftLeg.zScale = 1.0f;
    }

    @Override
    public boolean shouldTransform() {
        return this.transform;
    }

    @Override
    public void setShouldTransform(boolean transform) {
        this.transform = transform;
    }
}

