/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation;

import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.model.BonePose;
import cn.solarmoon.spark_core.animation.model.ModelInstance;
import cn.solarmoon.spark_core.animation.vanilla.VanillaModelHelper;
import cn.solarmoon.spark_core.compat.player_animator.PlayerAnimatorCompat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class}, priority=100)
public abstract class ItemInHandLayerMixin<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @Shadow
    @Final
    private ItemInHandRenderer itemInHandRenderer;

    public ItemInHandLayerMixin(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void render(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        IEntityAnimatable animatable;
        if (livingEntity instanceof IEntityAnimatable && VanillaModelHelper.shouldSwitchToAnim(animatable = (IEntityAnimatable)livingEntity) && !PlayerAnimatorCompat.INSTANCE.isAnimActive((Entity)livingEntity)) {
            String boneName = arm.getSerializedName() + "Item";
            if (!itemStack.isEmpty() && animatable.getModelController().getOriginModel().hasBone(boneName)) {
                float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
                PoseStack p = new PoseStack();
                Vec3 cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                p.translate(-cam.x, -cam.y, -cam.z);
                ModelInstance model = animatable.getModelController().getModel();
                if (model != null) {
                    BonePose pose = model.getPose().getBonePose(boneName);
                    Matrix4f ma = pose.getWorldBoneMatrix(Float.valueOf(partialTicks));
                    Vec3 pivot = animatable.getModelController().getOriginModel().getBone(boneName).getPivot();
                    p.mulPose(ma);
                    p.translate(pivot.x, pivot.y - 0.0625, pivot.z - 0.109375);
                    p.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    this.itemInHandRenderer.renderItem(livingEntity, itemStack, displayContext, arm == HumanoidArm.LEFT, p, buffer, packedLight);
                    ci.cancel();
                }
            }
        }
    }
}

