/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation;

import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.anim.AnimController;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private LivingEntity entity = (LivingEntity)this;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract float tickHeadTurn(float var1, float var2);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        IEntityAnimatable animatable;
        AnimController controller;
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof IEntityAnimatable && (controller = (animatable = (IEntityAnimatable)livingEntity).getAnimController()).isPlayingAnim() && controller.getLayers().values().stream().anyMatch(animLayer -> animLayer.isPlaying() && animLayer.getAnimations().stream().anyMatch(anim -> anim.getShouldTurnBody()))) {
            this.tickHeadTurn(this.getYRot(), 100.0f);
        }
    }
}

