/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation;

import cn.solarmoon.spark_core.animation.IAnimatable;
import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.model.ModelInstance;
import cn.solarmoon.spark_core.animation.vanilla.VanillaModelHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public class LivingEntityRendererMixin<T extends LivingEntity> {
    @Inject(method={"setupRotations"}, at={@At(value="RETURN")})
    private void offset(T entity, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale, CallbackInfo ci) {
        if (entity instanceof IEntityAnimatable) {
            ModelInstance model;
            IEntityAnimatable animatable = (IEntityAnimatable)entity;
            if (VanillaModelHelper.isHumanoidModel(entity) && animatable.getModelController().getOriginModel().hasBone("body") && (model = animatable.getModelController().getModel()) != null) {
                poseStack.mulPose(model.getPose().getBonePose("body").getSpaceBoneMatrix(Float.valueOf(partialTick)));
            }
        }
    }

    @Redirect(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getBedOrientation()Lnet/minecraft/core/Direction;", ordinal=0))
    private Direction getBedOrientation(LivingEntity instance) {
        return null;
    }

    @Redirect(method={"setupRotations"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasPose(Lnet/minecraft/world/entity/Pose;)Z", ordinal=0))
    private boolean sleepRotD(LivingEntity instance, Pose pose) {
        IAnimatable animatable;
        if (pose == Pose.SLEEPING && instance instanceof IAnimatable && VanillaModelHelper.shouldSwitchToAnim(animatable = (IAnimatable)instance)) {
            return false;
        }
        return instance.hasPose(pose);
    }

    @Redirect(method={"setupRotations"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasPose(Lnet/minecraft/world/entity/Pose;)Z", ordinal=1))
    private boolean sleepRot(LivingEntity instance, Pose pose) {
        if (pose == Pose.SLEEPING) {
            return false;
        }
        return instance.hasPose(pose);
    }
}

