/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation;

import cn.solarmoon.spark_core.animation.vanilla.ITransformModelPart;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public abstract class ModelPartMixin
implements ITransformModelPart {
    private final Vector3f pivot = new Vector3f();
    private ModelPart root = null;

    @Inject(method={"translateAndRotate"}, at={@At(value="HEAD")})
    private void transHead(PoseStack poseStack, CallbackInfo ci) {
        poseStack.translate(this.pivot.x, this.pivot.y, this.pivot.z);
        ModelPart r = this.root;
        ArrayList<ModelPart> list = new ArrayList<ModelPart>();
        while (r != null) {
            list.add(r);
            r = ((ITransformModelPart)r).getRoot();
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            ((ModelPart)list.get(i)).translateAndRotate(poseStack);
        }
    }

    @Inject(method={"translateAndRotate"}, at={@At(value="TAIL")})
    private void transTail(PoseStack poseStack, CallbackInfo ci) {
        poseStack.translate(-this.pivot.x, -this.pivot.y, -this.pivot.z);
    }

    @Override
    public Vector3f getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Vector3f pivot) {
        this.pivot.set((Vector3fc)pivot);
    }

    @Override
    @Nullable
    public ModelPart getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(ModelPart root) {
        this.root = root;
    }
}

