/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation.animatable;

import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.vanilla.VanillaModelHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.monster.AbstractIllager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IllagerModel.class})
public abstract class IllagerModelMixin<T extends AbstractIllager>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    @Shadow
    @Final
    private ModelPart leftArm;
    @Shadow
    @Final
    private ModelPart root;
    @Shadow
    @Final
    private ModelPart rightArm;
    @Shadow
    @Final
    private ModelPart head;
    @Shadow
    @Final
    private ModelPart leftLeg;
    @Shadow
    @Final
    private ModelPart rightLeg;
    @Shadow
    @Final
    private ModelPart arms;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/monster/AbstractIllager;FFFFF)V"}, at={@At(value="TAIL")})
    private void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        IEntityAnimatable animatable;
        ModelPart body = this.root.getChild("body");
        ModelPart nose = this.head.getChild("nose");
        if (entity instanceof IEntityAnimatable && VanillaModelHelper.shouldSwitchToAnim(animatable = (IEntityAnimatable)entity)) {
            this.setDefault();
            if (animatable.getAnimController().isPlayingAnim()) {
                float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
                VanillaModelHelper.setRoot(this.leftArm, body);
                VanillaModelHelper.setRoot(this.rightArm, body);
                VanillaModelHelper.setRoot(this.head, body);
                VanillaModelHelper.setPivot(animatable, "waist", body);
                VanillaModelHelper.applyTransform(animatable, "leftArm", this.leftArm, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "rightArm", this.rightArm, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "leftLeg", this.leftLeg, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "rightLeg", this.rightLeg, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "waist", body, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "head", this.head, partialTicks);
                VanillaModelHelper.applyTransform(animatable, "nose", nose, partialTicks);
            }
        }
    }

    private void setDefault() {
        this.leftLeg.setPos(1.9f, 12.0f, 0.0f);
        this.rightLeg.setPos(-1.9f, 12.0f, 0.0f);
        this.rightArm.setPos(-5.0f, 2.0f, 0.0f);
        this.leftArm.setPos(5.0f, 2.0f, 0.0f);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.head.zRot = 0.0f;
        this.head.xScale = 1.0f;
        this.head.yScale = 1.0f;
        this.head.zScale = 1.0f;
        this.rightArm.xScale = 1.0f;
        this.rightArm.yScale = 1.0f;
        this.rightArm.zScale = 1.0f;
        this.leftArm.xScale = 1.0f;
        this.leftArm.yScale = 1.0f;
        this.leftArm.zScale = 1.0f;
        this.rightLeg.xScale = 1.0f;
        this.rightLeg.yScale = 1.0f;
        this.rightLeg.zScale = 1.0f;
        this.leftLeg.xScale = 1.0f;
        this.leftLeg.yScale = 1.0f;
        this.leftLeg.zScale = 1.0f;
        this.arms.visible = false;
        this.leftArm.visible = true;
        this.rightArm.visible = true;
    }
}

