/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation.animatable;

import cn.solarmoon.spark_core.animation.vanilla.ITransformModelPart;
import cn.solarmoon.spark_core.animation.vanilla.VanillaModelHelper;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<T> {
    @Shadow
    @Final
    public ModelPart leftSleeve;
    @Shadow
    @Final
    public ModelPart rightSleeve;
    @Shadow
    @Final
    public ModelPart jacket;
    @Shadow
    @Final
    private ModelPart cloak;

    public PlayerModelMixin(ModelPart root, Function<ResourceLocation, RenderType> renderType) {
        super(root, renderType);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(ModelPart root, boolean slim, CallbackInfo ci) {
        VanillaModelHelper.setRoot(this.leftSleeve, this.body);
        VanillaModelHelper.setRoot(this.rightSleeve, this.body);
        VanillaModelHelper.setRoot(this.hat, this.body);
        VanillaModelHelper.setRoot(this.cloak, this.body);
        ((ITransformModelPart)this.jacket).setPivot(new Vector3f(0.0f, 0.75f, 0.0f));
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
    private void setup(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        ItemStack itemstack;
        PlayerSkin playerskin;
        AbstractClientPlayer livingEntity;
        if (entity instanceof AbstractClientPlayer && !(livingEntity = (AbstractClientPlayer)entity).isInvisible() && livingEntity.isModelPartShown(PlayerModelPart.CAPE) && (playerskin = livingEntity.getSkin()).capeTexture() != null && !(itemstack = livingEntity.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA)) {
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            double d0 = Mth.lerp((double)partialTicks, (double)livingEntity.xCloakO, (double)livingEntity.xCloak) - Mth.lerp((double)partialTicks, (double)livingEntity.xo, (double)livingEntity.getX());
            double d1 = Mth.lerp((double)partialTicks, (double)livingEntity.yCloakO, (double)livingEntity.yCloak) - Mth.lerp((double)partialTicks, (double)livingEntity.yo, (double)livingEntity.getY());
            double d2 = Mth.lerp((double)partialTicks, (double)livingEntity.zCloakO, (double)livingEntity.zCloak) - Mth.lerp((double)partialTicks, (double)livingEntity.zo, (double)livingEntity.getZ());
            float f = Mth.rotLerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.lerp((float)partialTicks, (float)livingEntity.oBob, (float)livingEntity.bob);
            f1 += Mth.sin((float)(Mth.lerp((float)partialTicks, (float)livingEntity.walkDistO, (float)livingEntity.walkDist) * 6.0f)) * 32.0f * f4;
            if (livingEntity.isCrouching()) {
                f1 += 25.0f;
            }
            this.cloak.z = 2.0f;
            this.cloak.xRot = (float)(-Math.toRadians(6.0f + f2 / 2.0f + f1));
            this.cloak.yRot = (float)Math.toRadians(180.0f - f3 / 2.0f);
            this.cloak.zRot = (float)Math.toRadians(f3 / 2.0f);
        }
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    private void setDefault(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        this.cloak.x = 0.0f;
    }
}

