/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation.humanoid.first_person;

import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.model.BonePose;
import cn.solarmoon.spark_core.animation.model.ModelInstance;
import cn.solarmoon.spark_core.compat.first_person_model.FirstPersonModelCompat;
import cn.solarmoon.spark_core.compat.real_camera.RealCameraCompat;
import cn.solarmoon.spark_core.event.CameraFollowHeadEvent;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    private final Camera camera = (Camera)this;
    @Shadow
    private float eyeHeightOld;
    @Shadow
    private float eyeHeight;
    @Shadow
    private float xRot;
    @Shadow
    private float yRot;

    @Shadow
    public abstract Vec3 getPosition();

    @Shadow
    protected abstract void setPosition(double var1, double var3, double var5);

    @Shadow
    protected abstract void move(float var1, float var2, float var3);

    @Shadow
    protected abstract void setRotation(float var1, float var2);

    @Shadow
    protected abstract float getMaxZoom(float var1);

    @Inject(method={"setup"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V", shift=At.Shift.AFTER)})
    private void setup(BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick, CallbackInfo ci) {
        CameraFollowHeadEvent event;
        IEntityAnimatable animatable;
        if (entity instanceof IEntityAnimatable && (animatable = (IEntityAnimatable)entity).getModelController().getOriginModel().hasBone("head") && (event = (CameraFollowHeadEvent)NeoForge.EVENT_BUS.post((Event)new CameraFollowHeadEvent(entity, this.camera, RealCameraCompat.INSTANCE.isActive() || FirstPersonModelCompat.INSTANCE.isActive()))).isEnabled()) {
            ModelInstance model = animatable.getModelController().getModel();
            if (model == null) {
                return;
            }
            BonePose pose = model.getPose().getBonePose("head");
            Vector3f pos = pose.getWorldBonePivot(Vec3.ZERO, Float.valueOf(partialTick));
            Vector3f pos2 = pose.getWorldBonePivot(new Vec3(0.0, (double)Mth.lerp((float)partialTick, (float)this.eyeHeightOld, (float)this.eyeHeight) - ((double)pos.y - Mth.lerp((double)partialTick, (double)entity.yo, (double)entity.getY())), 0.0), Float.valueOf(partialTick));
            this.setPosition(pos.x, pos2.y, pos.z);
        }
    }
}

