/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.animation.humanoid.first_person;

import cn.solarmoon.spark_core.animation.vanilla.player.PlayerAnimHelperKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>> {
    @Shadow
    @Final
    protected List<RenderLayer<T, M>> layers;
    private List<RenderLayer<T, M>> layersCache = new ArrayList<RenderLayer<T, M>>();
    private List<RenderLayer<T, M>> filteredLayers;
    private boolean lastShouldRender;

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void h(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            boolean shouldRender = PlayerAnimHelperKt.shouldRenderArmAnimInFirstPersonEvent(player).getShouldRender();
            if (shouldRender != this.lastShouldRender) {
                this.filteredLayers = this.layers.stream().filter(layer -> layer instanceof PlayerItemInHandLayer).toList();
                this.lastShouldRender = shouldRender;
            }
            if (shouldRender) {
                this.layersCache = new ArrayList<RenderLayer<T, M>>(this.layers);
                this.layers.clear();
                this.layers.addAll(this.filteredLayers);
            }
        }
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    private void p(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (this.lastShouldRender && !this.layersCache.isEmpty()) {
            this.layers.clear();
            this.layers.addAll(this.layersCache);
            this.layersCache.clear();
            this.lastShouldRender = false;
        }
    }
}

