/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.compat.geckolib;

import cn.solarmoon.spark_core.animation.IEntityAnimatable;
import cn.solarmoon.spark_core.animation.vanilla.VanillaModelHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.RenderUtil;

@Mixin(value={GeoArmorRenderer.class})
public class GeoArmorRendererMixin<T extends Item> {
    @Shadow
    protected Entity currentEntity;
    @Shadow
    protected GeoBone body;
    @Shadow
    protected GeoBone leftArm;
    @Shadow
    protected GeoBone rightArm;
    @Shadow
    protected GeoBone head;

    @Inject(method={"preRender(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/item/Item;Lsoftware/bernie/geckolib/cache/object/BakedGeoModel;Lnet/minecraft/client/renderer/MultiBufferSource;Lcom/mojang/blaze3d/vertex/VertexConsumer;ZFIII)V"}, at={@At(value="TAIL")})
    private void setArmorPivot(PoseStack poseStack, T animatable0, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour, CallbackInfo ci) {
        IEntityAnimatable animatable;
        Entity entity = this.currentEntity;
        if (entity instanceof IEntityAnimatable && VanillaModelHelper.shouldSwitchToAnim(animatable = (IEntityAnimatable)entity) && this.body != null) {
            Vector3f pivot = animatable.getModelController().getOriginModel().getBone("waist").getPivot().toVector3f().mul(16.0f);
            this.body.updatePivot(pivot.x, pivot.y, pivot.z);
        }
    }

    @Inject(method={"renderRecursively(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/item/Item;Lsoftware/bernie/geckolib/cache/object/GeoBone;Lnet/minecraft/client/renderer/RenderType;Lnet/minecraft/client/renderer/MultiBufferSource;Lcom/mojang/blaze3d/vertex/VertexConsumer;ZFIII)V"}, at={@At(value="INVOKE", target="Lsoftware/bernie/geckolib/renderer/GeoRenderer;renderRecursively(Lcom/mojang/blaze3d/vertex/PoseStack;Lsoftware/bernie/geckolib/animatable/GeoAnimatable;Lsoftware/bernie/geckolib/cache/object/GeoBone;Lnet/minecraft/client/renderer/RenderType;Lnet/minecraft/client/renderer/MultiBufferSource;Lcom/mojang/blaze3d/vertex/VertexConsumer;ZFIII)V")})
    public void renderRecursively(PoseStack poseStack, T animatable0, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour, CallbackInfo ci) {
        List<Object> bodyParts;
        IEntityAnimatable animatable;
        Entity entity = this.currentEntity;
        if (entity instanceof IEntityAnimatable && VanillaModelHelper.shouldSwitchToAnim(animatable = (IEntityAnimatable)entity) && (bodyParts = Arrays.asList(this.leftArm, this.rightArm, this.head)).contains(bone) && this.body != null) {
            RenderUtil.prepMatrixForBone((PoseStack)poseStack, (GeoBone)this.body);
        }
    }
}

