/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.event;

import cn.solarmoon.spark_core.event.EntityGetWeaponEvent;
import cn.solarmoon.spark_core.event.EntityTurnEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    private Entity entity = (Entity)this;

    @Inject(method={"getWeaponItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void getWeapon(CallbackInfoReturnable<ItemStack> cir) {
        ItemStack origin = (ItemStack)cir.getReturnValue();
        EntityGetWeaponEvent event = new EntityGetWeaponEvent(this.entity, origin);
        NeoForge.EVENT_BUS.post((Event)event);
        cir.setReturnValue((Object)event.getWeapon());
    }

    @Inject(method={"turn"}, at={@At(value="HEAD")}, cancellable=true)
    private void turn(double yRot, double xRot, CallbackInfo ci) {
        EntityTurnEvent event = new EntityTurnEvent((Entity)this, xRot, yRot);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }
}

