/*
 * Decompiled with CFR 0.152.
 */
package cn.solarmoon.spark_core.mixin.event;

import cn.solarmoon.spark_core.event.EntityGetWeaponEvent;
import cn.solarmoon.spark_core.event.PlayerFallEvent;
import cn.solarmoon.spark_core.event.PlayerGetAttackStrengthEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerMixin {
    private Player player = (Player)this;

    @Inject(method={"getAttackStrengthScale"}, at={@At(value="RETURN")}, cancellable=true)
    private void getAttackStrengthScale(float adjustTicks, CallbackInfoReturnable<Float> cir) {
        Float origin = (Float)cir.getReturnValue();
        PlayerGetAttackStrengthEvent event = new PlayerGetAttackStrengthEvent(this.player, adjustTicks, origin.floatValue());
        NeoForge.EVENT_BUS.post((Event)event);
        cir.setReturnValue((Object)Float.valueOf(event.getAttackStrengthScale()));
    }

    @Inject(method={"getWeaponItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void getWeapon(CallbackInfoReturnable<ItemStack> cir) {
        ItemStack origin = (ItemStack)cir.getReturnValue();
        EntityGetWeaponEvent event = new EntityGetWeaponEvent((Entity)this.player, origin);
        NeoForge.EVENT_BUS.post((Event)event);
        cir.setReturnValue((Object)event.getWeapon());
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")})
    private void fallOnGround(float fallDistance, float multiplier, DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        NeoForge.EVENT_BUS.post((Event)new PlayerFallEvent(this.player, fallDistance, multiplier, source));
    }
}

